/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractBodyParser;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BadMessageException;
import org.xlightweb.ComposedByteBuffer;
import org.xlightweb.IMessageHeaderParser;
import org.xsocket.connection.INonBlockingConnection;

abstract class AbstractHttpProtocolHandler {
    private static final Logger LOG = Logger.getLogger(AbstractHttpProtocolHandler.class.getName());
    static final int BODY_TYPE_EMTPY = 0;
    static final int BODY_TYPE_BOUND = 1;
    static final int BODY_TYPE_CHUNKED = 2;
    static final int BODY_TYPE_SIMPLE = 3;
    static final int BODY_TYPE_MULTIPART_BYTERANGE = 4;
    static final int INIT = 0;
    static final int RECEIVING_HEADER = 5;
    static final int RECEIVING_BODY = 10;
    private int state = 0;
    private IMessageHeaderParser headerParser = null;
    private AbstractBodyParser bodyParser = null;

    AbstractHttpProtocolHandler() {
    }

    protected final int getState() {
        return this.state;
    }

    protected final void setState(int state) {
        this.state = state;
    }

    protected final AbstractBodyParser getBodyParser() {
        return this.bodyParser;
    }

    protected final void setBodyParser(AbstractBodyParser bodyParser) {
        this.bodyParser = bodyParser;
    }

    protected IMessageHeaderParser getHeaderParser() {
        return this.headerParser;
    }

    protected void setHeaderParser(IMessageHeaderParser headerParser) {
        this.headerParser = headerParser;
    }

    protected final void parserBody(ComposedByteBuffer rawData) throws IOException {
        boolean isComplete = this.getBodyParser().parse(rawData);
        if (isComplete) {
            this.reset();
        }
    }

    protected final void reset() {
        this.headerParser.recycle();
        this.headerParser = null;
        this.bodyParser = null;
        this.state = 0;
    }

    public final void onDisconnect() {
        if (this.bodyParser != null) {
            this.bodyParser.onDisconnect();
        }
    }

    protected abstract void onData(AbstractHttpConnection var1, INonBlockingConnection var2, ComposedByteBuffer var3) throws BadMessageException, IOException;

    protected void onException(AbstractHttpConnection httpConnection, IOException ioe, ComposedByteBuffer rawData) {
        switch (this.getState()) {
            case 0: {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + httpConnection.getId() + "] connection closed (by peer?)");
                }
                return;
            }
            case 5: {
                IMessageHeaderParser headerParser = this.getHeaderParser();
                if (headerParser == null) break;
                headerParser.onException(ioe, rawData);
                break;
            }
            default: {
                AbstractBodyParser bodyParser = this.getBodyParser();
                if (bodyParser == null) break;
                bodyParser.onException(ioe, rawData);
            }
        }
    }
}

