/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.GraphViewNotificationAdapter;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutMode;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.windows.TopComponent;

public class TabularGraphOpenAction
extends NewGraphAction {
    private GraphID _graphID = null;
    private String _name = null;

    public void setGraph(GraphID graphID, String name) {
        this._graphID = graphID;
        this._name = name;
    }

    public void performAction() {
        if (this._graphID == null) {
            throw new IllegalStateException("Graph not set.");
        }
        GraphLifeCycleManager.getDefault().fireGraphOpening(this._graphID);
        GraphLifeCycleManager.getDefault().fireGraphLoading(this._graphID);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("graphLoadingDone")) {
                    GraphViewNotificationAdapter.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TabularGraphOpenAction.this.RelayoutNewGraph();
                        }
                    });
                }
            }
        };
        GraphViewNotificationAdapter.getDefault().addPropertyChangeListener(listener);
        super.performAction();
        this._graphID = null;
        this._name = null;
    }

    protected DataObject getDataObject() throws DataObjectNotFoundException, IOException {
        DataObject gdo = super.getDataObject();
        GraphCookie graphCookie = (GraphCookie)gdo.getCookie(GraphCookie.class);
        graphCookie.setGraphID(this._graphID);
        graphCookie.onGraphLoaded();
        this.renameDataObject(gdo, this._name);
        gdo.setModified(true);
        return gdo;
    }

    private void RelayoutNewGraph() {
        GraphView graphView = this.getTopGraphView();
        graphView.setLayout(new LayoutSettings(true, LayoutMode.CIRCULAR), true);
        graphView.doLayout();
    }

    private GraphView getTopGraphView() {
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null) {
            GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
            return cookie.getGraphView();
        }
        return null;
    }
}

