/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.list;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.inspect.InspectorRegistry;
import com.paterva.maltego.detailview.list.LinkSyncButton;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.treelist.parts.link.LinkTable;
import com.paterva.maltego.ui.graph.SelectionProvider;
import com.paterva.maltego.util.IconSize;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import yguard.A.A.H;
import yguard.A.I.M;
import yguard.A.J.SA;
import yguard.A.J.U;

public class LinkListDetailView
extends JPanel
implements SelectionProvider {
    private final LinkTable _table;
    private final ChangeSupport _selectionChangeSupport = new ChangeSupport((Object)this);
    private MouseAdapter _clickEditListener;
    private final Color _bg;
    private final JPanel _topPanel;
    private final JPanel _cornerPanel;
    private final JPanel _filterPanel;

    public LinkListDetailView() {
        this.setLayout(new BorderLayout());
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this._bg = laf.getColor("detail-view-empty-bg");
        this._table = this.createLinkTable("Detail View Links");
        this._table.setSelectionBackground(laf.getColor("detail-view-list-selection-bg"));
        this._table.setSelectionForeground(laf.getColor("detail-view-list-selection-fg"));
        this._table.setBackground(this._bg);
        this._table.setForeground(laf.getColor("detail-view-list-fg"));
        this._table.setGridColor(laf.getColor("detail-view-list-grid-color"));
        JScrollPane scrollPane = new JScrollPane((Component)this._table);
        scrollPane.getViewport().setBackground(this._bg);
        this.add(scrollPane);
        this._cornerPanel = new JPanel(new BorderLayout());
        this._cornerPanel.setBackground(this._bg);
        this._cornerPanel.setMaximumSize(new Dimension(100, 30));
        this._cornerPanel.setBorder(new EmptyBorder(1, 0, 1, 0));
        this._cornerPanel.add(this.createCornerComponent());
        this._topPanel = new JPanel(new BorderLayout());
        this._topPanel.setBackground(this._bg);
        this._topPanel.add((Component)this._cornerPanel, "West");
        this._topPanel.add(Box.createHorizontalGlue());
        this._filterPanel = this._table.getFilter();
        this._filterPanel.setBackground(this._bg);
        this._filterPanel.setBorder(new EmptyBorder(1, 1, 1, 0));
        this._topPanel.add(this._filterPanel);
        this.add((Component)this._topPanel, "North");
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    LinkListDetailView.this._selectionChangeSupport.fireChange();
                }
            }
        });
    }

    protected LinkTable getTable() {
        return this._table;
    }

    protected JPanel getTopPanel() {
        return this._topPanel;
    }

    protected JPanel getCornerPanel() {
        return this._cornerPanel;
    }

    protected JPanel getFilterPanel() {
        return this._filterPanel;
    }

    protected JComponent createCornerComponent() {
        LinkSyncButton linkSyncButton = new LinkSyncButton(this._table);
        linkSyncButton.setBorderPainted(false);
        int iconSize = IconSize.TINY.getSize();
        linkSyncButton.setPreferredSize(new Dimension(4 + iconSize, 8 + iconSize));
        return linkSyncButton;
    }

    protected LinkTable createLinkTable(String name) {
        return LinkTable.create((String)name);
    }

    protected MouseAdapter createClickEditListener() {
        return new ClickEditListener();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._table.addListeners();
        this._clickEditListener = this.createClickEditListener();
        this._table.addMouseListener((MouseListener)this._clickEditListener);
    }

    @Override
    public void removeNotify() {
        this._table.removeMouseListener((MouseListener)this._clickEditListener);
        this._clickEditListener = null;
        this._table.removeListeners();
        super.removeNotify();
    }

    public void setLinks(GraphID topGraphID, Set<LinkID> selectedModelLinks) {
        this._table.getTreelistModel().setModelParts(topGraphID, selectedModelLinks);
        this._selectionChangeSupport.fireChange();
    }

    private void zoomToViewEdge(int modelRow) {
        try {
            GraphID graphID = this._table.getTreelistModel().getGraphID();
            LinkID linkID = (LinkID)this._table.getTreeModel().getPartID(modelRow);
            GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            LinkID viewLink = graphStoreView.getModelViewMappings().getViewLink(linkID);
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            SA graph2D = (SA)wrapper.getGraph();
            H edge = wrapper.edge(viewLink);
            U view = (U)graph2D.\u00f1();
            M source = graph2D.S(edge);
            M target = graph2D.O(edge);
            M center = new M((source.A + target.A) / 2.0, (source.D + target.D) / 2.0);
            view.focusView(1.0, (Point2D)new Point2D.Double(center.A, center.D), true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void inspect(int modelRow) {
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        LinkID linkID = (LinkID)this._table.getTreeModel().getPartID(modelRow);
        InspectorRegistry.forGraph(graphID).inspect(linkID);
    }

    public Set<EntityID> getSelectedModelEntities() {
        return Collections.EMPTY_SET;
    }

    public Set<LinkID> getSelectedModelLinks() {
        return this._table.getTreeModel().getSelectedPartIDs();
    }

    public void addSelectionChangeListener(ChangeListener listener) {
        this._selectionChangeSupport.addChangeListener(listener);
    }

    public void removeSelectionChangeListener(ChangeListener listener) {
        this._selectionChangeSupport.removeChangeListener(listener);
    }

    private class ClickEditListener
    extends MouseAdapter {
        private ClickEditListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            int viewRow = LinkListDetailView.this._table.rowAtPoint(point);
            int viewColumn = LinkListDetailView.this._table.columnAtPoint(point);
            int modelColumn = LinkListDetailView.this._table.convertColumnIndexToModel(viewColumn);
            if (modelColumn == 0 && e.getClickCount() == 2) {
                int modelRow = LinkListDetailView.this._table.convertRowIndexToModel(viewRow);
                LinkListDetailView.this.zoomToViewEdge(modelRow);
            } else if (modelColumn > 0) {
                int modelRow = LinkListDetailView.this._table.convertRowIndexToModel(viewRow);
                switch (--modelColumn) {
                    case 0: {
                        LinkListDetailView.this.inspect(modelRow);
                        break;
                    }
                }
            }
        }
    }
}

