/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.LayoutView;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettings;
import com.paterva.maltego.ui.graph.view2d.layout.LayoutSettingsWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.WeakListeners;

public class LayoutChangePropagator {
    private static LayoutChangePropagator _instance;
    private final PropertyChangeListener _listener = new LayoutChangeListener();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport(this);

    private LayoutChangePropagator() {
    }

    public static synchronized LayoutChangePropagator getInstance() {
        if (_instance == null) {
            _instance = new LayoutChangePropagator();
        }
        return _instance;
    }

    public void register(LayoutView view) {
        view.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, (Object)view));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    private class LayoutChangeListener
    implements PropertyChangeListener {
        private LayoutChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof ViewControlAdapter) {
                ViewControlAdapter adapter = (ViewControlAdapter)source;
                GraphID graphID = adapter.getGraphID();
                LayoutSettingsWrapper oldSettings = new LayoutSettingsWrapper(graphID, (LayoutSettings)evt.getOldValue());
                LayoutSettingsWrapper newSettings = new LayoutSettingsWrapper(graphID, (LayoutSettings)evt.getNewValue());
                LayoutChangePropagator.this._changeSupport.firePropertyChange(evt.getPropertyName(), oldSettings, newSettings);
            }
        }
    }
}

