/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing;

import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.PropertyValueFormat;
import com.paterva.maltego.util.Args;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PropertyDescriptor
implements Comparable {
    private Class _type;
    private String _name;
    private String _displayName;
    private boolean _nullable = true;
    private boolean _hidden = false;
    private boolean _readonly = false;
    private String _htmlDisplayName = null;
    private String _image = null;
    private PropertyValueFormat _propertyValueFormat = PropertyValueFormat.STRING;

    public PropertyDescriptor(Class type, String name) {
        this(type, name, name);
    }

    public PropertyDescriptor(Class type, String name, String displayName) {
        if (name == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this._type = type;
        this._name = name;
        this._displayName = displayName;
    }

    public PropertyDescriptor(PropertyDescriptor descriptor) {
        this(descriptor.getType(), descriptor.getName(), descriptor.getDisplayName());
        this._nullable = descriptor.isNullable();
        this._hidden = descriptor.isHidden();
        this._readonly = descriptor.isReadonly();
    }

    public Class getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getDisplayName() {
        if (this._displayName == null) {
            return this._name;
        }
        return this._displayName;
    }

    public void setDisplayName(String displayName) {
        this._displayName = displayName;
    }

    public boolean isNullable() {
        return this._nullable;
    }

    public void setNullable(boolean nullable) {
        this._nullable = nullable;
    }

    public boolean isHidden() {
        return this._hidden;
    }

    public void setHidden(boolean hidden) {
        this._hidden = hidden;
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        this._readonly = readonly;
    }

    public String getDescription() {
        return this._displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public void setPropertyValueFormat(PropertyValueFormat propertyValueFormat) {
        Args.notNull((Object)((Object)propertyValueFormat), (String)"propertyValueFormat");
        this._propertyValueFormat = propertyValueFormat;
    }

    public PropertyValueFormat getPropertyValueFormat() {
        return this._propertyValueFormat;
    }

    public boolean deepEquals(PropertyDescriptor other) {
        return Objects.equals(this._type, other._type) && Objects.equals(this._name, other._name) && Objects.equals(this._displayName, other._displayName) && Objects.equals(this._htmlDisplayName, other._htmlDisplayName) && Objects.equals(this._image, other._image) && this._nullable == other._nullable && this._readonly == other._readonly && this._hidden == other._hidden && this._propertyValueFormat.equals((Object)other._propertyValueFormat);
    }

    public boolean equals(PropertyDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        return this._name.equals(descriptor.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyDescriptor) {
            return this.equals((PropertyDescriptor)obj);
        }
        return false;
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public String getHtmlDisplayName() {
        return this._htmlDisplayName;
    }

    public String getImage() {
        return this._image;
    }

    public void setHtmlDisplayName(String htmlDisplayName) {
        this._htmlDisplayName = htmlDisplayName;
    }

    public void setImage(String image) {
        this._image = image;
    }

    public int compareTo(Object o) {
        if (o instanceof PropertyDescriptor) {
            return this.getName().compareTo(((PropertyDescriptor)o).getName());
        }
        return -1;
    }

    public void refreshValues(DataSource data) {
        data.setValue(this, this.evaluate(data.getValue(this), data));
    }

    public List<PropertyDescriptor> getLinkedProperties() {
        return new ArrayList<PropertyDescriptor>(0);
    }

    protected Object evaluate(Object oldValue, DataSource inputs) {
        return oldValue;
    }
}

