/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.auth;

public class CloudAuthHtmlUtil {
    public static String getAuthenticationCompleteHtml(boolean showCloudCasesUrl, String cloudCasesUrl, String cloudCasesText) {
        return CloudAuthHtmlUtil.getBrowserSuccessHtml("Authentication complete", showCloudCasesUrl, cloudCasesUrl, cloudCasesText);
    }

    public static String getLogoutCompleteHtml() {
        return CloudAuthHtmlUtil.getBrowserSuccessHtml("Logout successful", false, "", "");
    }

    private static String getBrowserSuccessHtml(String successMessage, boolean showCloudCasesUrl, String cloudCasesUrl, String cloudCasesText) {
        String successHtml = "<!doctype html>\n<html>\n\n<head>\n  <title>Maltego</title>\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\" />\n  <style type=\"text/css\">\n    html,\n    body {\n      margin: 0;\n      padding: 0;\n      color: black;\n      font-family: Roboto, sans-serif;\n      background: #303849;\n      color: white;\n    }\n\n    .header {\n      position: fixed;\n      left: 0;\n      right: 0;\n      top: 0;\n      padding: 1rem;\n    }\n\n    h1 {\n      font-size: 27px;\n      font-weight: 400;\n      margin-top: 0;\n    }\n\n    p {\n      font-size: 16px;\n      line-height: 24px;\n      color: #C1C3C7;\n      font-weight: 400;\n    }\n\n    .success-wrapper {\n      border: 3px solid #B2D3B3;\n      border-radius: 50%;\n      position: absolute;\n      top: calc(50vh - 187px);\n      left: calc(50vw - 187px);\n      width: 375px;\n      height: 375px;\n    }\n\n    .success-inner {\n      width: 80%;\n      text-align: center;\n      margin: 10% 10% 0 10%;\n    }\n\n    .success-inner svg {\n      width: 8rem;\n      height: 8rem;\n    }\n\n    .success-inner a {\n      color: #ffb30f;\n    }\n\n    footer {\n      position: fixed;\n      left: 0;\n      bottom: 0;\n      right: 0;\n      padding: 1rem;\n      font-size: 12px;\n      color: #999DA6;\n      display: grid;\n      grid-template-columns: 1fr 1fr;\n    }\n\n    .footer-links {\n      text-align: right;\n    }\n\n    a {\n      color: #999DA6;\n      text-decoration: none;\n      display: inline-block;\n      margin-left: 0.5rem;\n    }\n\n    a:hover {\n      text-decoration: underline;\n    }\n\n    @media screen and (max-width: 400px) {\n      .success-wrapper {\n        top: calc(50vh - 137px);\n        left: calc(50vw - 137px);\n        width: 275px;\n        height: 275px;\n      }\n\n      h1 {\n        font-size: 1.5rem;\n      }\n\n      .success-inner svg {\n        width: 4rem;\n        height: 4rem;\n        stroke-width: 1;\n      }\n    }\n  </style>\n</head>\n\n<body>\n  <div class=\"header\">\n    <svg width=\"172\" height=\"30\" viewBox=\"0 0 172 30\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n      <path\n        d=\"M29.5851 14.7202L27.2892 14.7286V14.7872C27.1552 18.2143 25.8816 21.0967 23.527 23.359C22.4126 24.4483 21.1055 25.303 19.6643 25.8811C18.2231 26.4593 16.6813 26.7442 15.1312 26.7274H14.6117C8.73797 26.5096 3.91162 22.01 3.11561 16.0274C2.73855 13.2958 3.3586 10.5223 4.86684 8.21805C7.18784 4.60667 10.5814 2.67948 14.9804 2.46163H15.039V0.18252L14.9888 0.174141C14.8296 0.149004 14.662 0.140625 14.4944 0.140625C13.0281 0.140625 10.64 0.72716 9.048 1.49803C6.24938 2.78841 3.94514 4.93345 2.46204 7.63152C0.962188 10.3212 0.375653 13.4298 0.786227 16.4798C1.08787 18.7589 1.92578 20.9291 3.22454 22.8228C4.52329 24.7164 6.25776 26.2666 8.2855 27.3559C10.3132 28.4368 12.5672 29.0317 14.8631 29.0736C17.1589 29.1155 19.438 28.6127 21.4993 27.5989C27.2222 24.7835 29.6773 19.1611 29.5851 14.7789V14.7202Z\"\n        fill=\"white\" />\n      <path\n        d=\"M22.6721 14.4688V14.4101C22.7224 12.1729 21.3985 9.18996 18.3485 7.76551C17.3514 7.30467 16.2621 7.06167 15.1645 7.06167C13.849 7.05329 12.5586 7.39684 11.4107 8.0504C10.2627 8.70397 9.31589 9.64243 8.63718 10.782C7.96686 11.9215 7.61494 13.2119 7.59818 14.5274C7.5898 15.8429 7.91658 17.1417 8.56177 18.2896C10.0281 20.9123 12.7848 22.1021 14.7372 22.1021H15.0472V19.8314L14.9885 19.823C11.6788 19.5549 9.92756 16.9155 9.9527 14.5526C9.96108 13.2957 10.4303 12.0975 11.2598 11.1507C12.0894 10.2038 13.2373 9.60053 14.4858 9.44971C14.712 9.42457 14.9466 9.40781 15.1729 9.40781C16.1784 9.39943 17.1671 9.70108 17.9966 10.2709C18.6921 10.7233 19.2619 11.335 19.6724 12.0556C20.083 12.7762 20.3176 13.5806 20.3511 14.4101V14.4688H22.6721Z\"\n        fill=\"white\" />\n      <path\n        d=\"M12.6592 14.5026C12.6592 15.8097 13.7149 16.8655 15.0221 16.8655C16.3292 16.8655 17.385 15.8097 17.385 14.5026C17.385 13.1955 16.3292 12.1313 15.0221 12.1397C13.7149 12.1397 12.6592 13.1955 12.6592 14.5026Z\"\n        fill=\"white\" />\n      <path\n        d=\"M7.56568 6.72676L8.47062 7.53953L9.28339 8.27689L9.32529 8.23499C10.5654 7.10382 12.1071 6.36646 13.7662 6.10671C15.4169 5.84696 17.1178 6.08157 18.6428 6.77703C20.1678 7.4725 21.4582 8.60367 22.3547 10.0197C23.2429 11.4358 23.7038 13.0865 23.6703 14.7623C23.6367 16.4465 23.1089 18.072 22.162 19.4546C21.2152 20.8371 19.8745 21.9096 18.3244 22.5381C16.7743 23.1749 15.065 23.3341 13.4227 23.0073C11.7804 22.6805 10.2721 21.8845 9.07391 20.7031L9.03202 20.6612L7.82543 21.9767L7.47351 22.3705L7.51541 22.4124C9.37556 24.3731 12.1993 25.5462 15.1236 25.5462C18.0311 25.5462 20.813 24.3982 22.8659 22.3537C24.9187 20.3092 26.0834 17.5358 26.0834 14.6282C26.0834 11.7207 24.9355 8.93884 22.891 6.88596C20.8465 4.83309 18.0647 3.67678 15.1655 3.6684C12.3585 3.64326 9.65207 4.72416 7.61595 6.68486L7.56568 6.72676Z\"\n        fill=\"white\" />\n      <path d=\"M79.0978 19.0106V19.0606H79.1478H86.2284V21.4408H76.1059V7.52266H79.0978V19.0106Z\" fill=\"white\"\"/>\n      <path d=\" M62.4567 18.4158H62.4232L62.4105 18.4467L61.1664 21.4658H58.1264L64.3326 7.54756H67.3847L73.6076\n        21.4658H70.4922L69.2481 18.4467L69.2353 18.4158H69.2019H62.4567ZM63.3908 16.1592L63.3623\n        16.2283H63.4371H68.255H68.3299L68.3012 16.1591L65.888 10.3357L65.8418 10.224L65.7956 10.3357L63.3908 16.1592Z\"\n        fill=\"white\" />\n      <path\n        d=\"M55.6526 21.4574H52.8702L52.8452 12.7009L52.8447 12.5201L52.7522 12.6755L48.9986 18.9846L48.9984 18.9849L47.7592 21.034L47.1908 20.0995L47.1241 19.9828L47.1241 19.9828L47.1234 19.9816L42.7914 12.8678L42.6987 12.7155V12.8938V21.4658H39.9163V7.53926H42.3936L47.7668 16.4555L47.81 16.5272L47.8526 16.4552L53.1421 7.53926H55.611L55.6526 21.4574Z\"\n        fill=\"white\" />\n      <path\n        d=\"M91.0203 9.94407V9.89407H90.9703H86.4704V7.51387H98.5536V9.89407H94.0537H94.0037V9.94407V21.4404H91.0203V9.94407Z\"\n        fill=\"white\" />\n      <path\n        d=\"M144.662 10.7998L144.662 10.7999C145.319 11.8808 145.652 13.1034 145.652 14.4775C145.652 15.8517 145.328 17.0826 144.662 18.1801C143.997 19.2617 143.09 20.1186 141.933 20.7429C140.776 21.3671 139.477 21.6837 138.019 21.6837C136.568 21.6837 135.253 21.3671 134.087 20.7429C132.93 20.1186 132.024 19.2701 131.358 18.1804C130.71 17.0827 130.385 15.8433 130.385 14.4775C130.385 13.1117 130.71 11.889 131.358 10.7997C132.024 9.70141 132.93 8.8363 134.087 8.2121C135.261 7.58784 136.568 7.27119 138.019 7.27119C139.477 7.27119 140.776 7.58788 141.933 8.21203C143.09 8.83626 143.997 9.70146 144.662 10.7998ZM140.372 18.5934L140.372 18.5934L140.373 18.593C141.076 18.1862 141.627 17.6183 142.017 16.9067C142.424 16.1946 142.627 15.3816 142.627 14.4775C142.627 13.5732 142.424 12.7686 142.017 12.0484C141.627 11.3367 141.076 10.7769 140.373 10.3869C139.669 9.98012 138.881 9.77708 138.019 9.77708C137.156 9.77708 136.368 9.98014 135.664 10.3869C134.97 10.7768 134.41 11.328 134.003 12.0481L134.003 12.0483C133.605 12.7605 133.41 13.5736 133.41 14.4775C133.41 15.3819 133.613 16.1861 134.003 16.9061L134.003 16.9061L134.003 16.9068C134.41 17.6267 134.961 18.1862 135.664 18.593L135.665 18.5934C136.368 18.9833 137.156 19.1779 138.019 19.1779C138.889 19.1779 139.669 18.9833 140.372 18.5934Z\"\n        fill=\"white\" />\n      <path\n        d=\"M104.536 15.5085H104.486V15.5585V19.0525V19.1025H104.536H112.229V21.4408H101.52V7.52266H111.969V9.86097H104.536H104.486V9.91097V13.2039V13.2539H104.536H110.603V15.5085H104.536Z\"\n        fill=\"white\" />\n      <path\n        d=\"M118.226 20.7236L118.226 20.7235C117.153 20.1665 116.305 19.3603 115.665 18.3037C115.025 17.2398 114.708 16.0865 114.708 14.6032C114.708 13.1782 115.033 11.9137 115.682 10.8162C116.347 9.70149 117.262 8.83639 118.427 8.21214C119.601 7.5879 120.917 7.27119 122.384 7.27119C123.61 7.27119 124.718 7.47963 125.725 7.88752C126.675 8.28044 127.47 8.83398 128.129 9.56401L126.232 11.316C125.207 10.2823 123.974 9.7687 122.543 9.7687C121.614 9.7687 120.784 9.97148 120.056 10.3782C119.327 10.7765 118.759 11.3362 118.352 12.0651C117.945 12.7941 117.742 13.6322 117.742 14.578C117.742 15.5658 117.928 16.2928 118.327 16.9968L118.327 16.9972C118.734 17.7002 119.277 18.2349 119.955 18.5999L119.956 18.6002C120.558 18.9137 121.21 19.083 121.904 19.1169L121.904 19.1169H121.906H124.923H124.973V19.0669V15.3045H127.671V21.5642H127.669H127.665H127.662H127.658H127.653H127.649H127.645H127.64H127.636H127.631H127.626H127.621H127.616H127.611H127.606H127.601H127.595H127.589H127.584H127.578H127.572H127.566H127.56H127.553H127.547H127.54H127.534H127.527H127.52H127.513H127.506H127.499H127.492H127.484H127.477H127.469H127.461H127.454H127.446H127.438H127.43H127.421H127.413H127.405H127.396H127.387H127.379H127.37H127.361H127.352H127.343H127.334H127.324H127.315H127.305H127.296H127.286H127.276H127.266H127.257H127.246H127.236H127.226H127.216H127.205H127.195H127.184H127.174H127.163H127.152H127.141H127.13H127.119H127.108H127.096H127.085H127.074H127.062H127.05H127.039H127.027H127.015H127.003H126.991H126.979H126.967H126.955H126.942H126.93H126.917H126.905H126.892H126.88H126.867H126.854H126.841H126.828H126.815H126.802H126.789H126.775H126.762H126.749H126.735H126.722H126.708H126.694H126.68H126.667H126.653H126.639H126.625H126.611H126.597H126.582H126.568H126.554H126.539H126.525H126.51H126.496H126.481H126.467H126.452H126.437H126.422H126.407H126.392H126.377H126.362H126.347H126.332H126.317H126.301H126.286H126.271H126.255H126.24H126.224H126.209H126.193H126.177H126.161H126.146H126.13H126.114H126.098H126.082H126.066H126.05H126.034H126.018H126.002H125.985H125.969H125.953H125.936H125.92H125.904H125.887H125.871H125.854H125.838H125.821H125.804H125.788H125.771H125.754H125.737H125.721H125.704H125.687H125.67H125.653H125.636H125.619H125.602H125.585H125.568H125.551H125.534H125.516H125.499H125.482H125.465H125.448H125.43H125.413H125.396H125.378H125.361H125.343H125.326H125.309H125.291H125.274H125.256H125.239H125.221H125.203H125.186H125.168H125.151H125.133H125.115H125.098H125.08H125.062H125.045H125.027H125.009H124.992H124.974H124.956H124.938H124.921H124.903H124.885H124.867H124.85H124.832H124.814H124.796H124.778H124.761H124.743H124.725H124.707H124.689H124.672H124.654H124.636H124.618H124.6H124.583H124.565H124.547H124.529H124.511H124.494H124.476H124.458H124.44H124.423H124.405H124.387H124.369H124.352H124.334H124.316H124.298H124.281H124.263H124.245H124.228H124.21H124.192H124.175H124.157H124.14H124.122H124.105H124.087H124.07H124.052H124.035H124.017H124H123.982H123.965H123.947H123.93H123.913H123.895H123.878H123.861H123.844H123.827H123.809H123.792H123.775H123.758H123.741H123.724H123.707H123.69H123.673H123.656H123.639H123.622H123.605H123.589H123.572H123.555H123.538H123.522H123.505H123.488H123.472H123.455H123.439H123.422H123.406H123.39H123.373H123.357H123.341H123.325H123.308H123.292H123.276H123.26H123.244H123.228H123.212H123.196H123.181H123.165H123.149H123.134H123.118H123.102H123.087H123.071H123.056H123.041H123.025H123.01H122.995H122.98H122.964H122.949H122.934H122.919H122.905H122.89H122.875H122.86H122.846H122.831H122.816H122.802H122.788H122.773H122.759H122.745H122.73H122.716H122.702H122.688H122.674H122.661H122.647H122.633H122.619H122.606H122.592H122.579H122.565H122.552H122.539H122.526H122.513H122.5H122.487H122.474H122.461H122.448H122.435H122.423H122.41H122.398H122.386H122.373H122.361H122.349H122.337H122.325H122.313H122.301H122.289H122.278H122.266H122.255H122.243H122.232H122.221H122.21H122.198H122.187H122.177H122.166H122.155H122.144H122.134H122.123H122.113H122.103H122.092H122.082H122.072H122.062H122.053H122.043H122.033H122.024H122.014H122.005H121.996H121.986H121.977H121.968H121.959H121.951H121.942H121.933H121.925H121.917H121.908H121.9H121.892H121.884H121.876H121.868H121.861H121.853H121.846H121.838H121.831H121.824H121.817H121.81H121.803H121.797H121.79H121.784H121.777H121.771H121.765H121.759H121.753H121.747H121.741H121.736H121.73H121.725H121.72H121.715H121.71H121.705H121.7H121.695H121.691H121.686H121.682H121.678H121.674H121.67H121.666H121.663H121.659H121.656H121.652H121.649H121.646H121.643H121.64H121.638H121.635H121.633H121.63H121.628H121.626H121.624H121.623H121.621H121.619H121.618H121.617H121.616H121.615H121.614H121.613H121.613H121.612C121.583 21.5642 121.532 21.5621 121.487 21.56L121.43 21.5572L121.413 21.5562L121.408 21.556L121.407 21.5559L121.407 21.5559L121.407 21.5559L121.406 21.5559L121.406 21.5559L121.299 21.5476L121.299 21.5476L121.297 21.5475C120.19 21.4892 119.166 21.2145 118.226 20.7236Z\"\n        fill=\"white\" />\n    </svg>\n  </div>\n  <div class=\"success-wrapper\">\n    <div class=\"success-inner\">\n      <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"#B2D3B3\"\n        stroke-width=\"0.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\" class=\"feather feather-check\">\n        <polyline points=\"20 6 9 17 4 12\" />\n      </svg>\n      <h1>\n" + successMessage + "      </h1>\n      <p>\n        You can close the browser and return to&nbsp;the&nbsp;application\n      </p>\n" + (showCloudCasesUrl ? "      <a href='" + cloudCasesUrl + "'>" + cloudCasesText + "</a>\n" : "") + "    </div>\n  </div>\n  <footer>\n    <div>\n      Copyright 2023 Maltego Technologies GmbH\n    </div>\n    <div class=\"footer-links\">\n      <a href=\"https://www.maltego.com/legal-notice/\" target=\"_blank\">\n        Legal Notice\n      </a>\n      <a href=\"https://www.maltego.com/data-privacy/\" target=\"_blank\">\n        Data Privacy\n      </a>\n      <a href=\"https://www.maltego.com/license-agreement/\" tarket=\"_blank\">\n        License Agreement\n      </a>\n    </div>\n  </footer>\n</body>\n\n</html>";
        return successHtml;
    }

    public static String getBrowserErrorHtml() {
        return "<!doctype html>\n<html>\n\n<head>\n  <title>Maltego</title>\n  <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, user-scalable=no\" />\n  <style type=\"text/css\">\n    html,\n    body {\n      margin: 0;\n      padding: 0;\n      color: black;\n      font-family: Roboto, sans-serif;\n      background: #303849;\n      color: white;\n    }\n\n    .header {\n      position: fixed;\n      left: 0;\n      right: 0;\n      top: 0;\n      padding: 1rem;\n    }\n\n    h1 {\n      font-size: 27px;\n      font-weight: 400;\n      margin-top: 0;\n    }\n\n    p {\n      font-size: 16px;\n      line-height: 24px;\n      color: #C1C3C7;\n      font-weight: 400;\n    }\n\n    .success-wrapper {\n      border: 3px solid #CE3737;\n      position: absolute;\n      top: calc(50vh - 187px);\n      left: calc(50vw - 187px);\n      width: 375px;\n      height: 375px;\n    }\n\n    .success-inner {\n      width: 90%;\n      text-align: center;\n      margin: 10% 5% 0 5%;\n    }\n\n    .success-inner svg {\n      width: 8rem;\n      height: 8rem;\n    }\n\n    .success-inner a {\n      color: #C8962A;\n    }\n\n    footer {\n      position: fixed;\n      left: 0;\n      bottom: 0;\n      right: 0;\n      padding: 1rem;\n      font-size: 12px;\n      color: #999DA6;\n      display: grid;\n      grid-template-columns: 1fr 1fr;\n    }\n\n    .footer-links {\n      text-align: right;\n    }\n\n    a {\n      color: #999DA6;\n      text-decoration: none;\n      display: inline-block;\n      margin-left: 0.5rem;\n    }\n\n    a:hover {\n      text-decoration: underline;\n    }\n\n    @media screen and (max-width: 400px) {\n      .success-wrapper {\n        top: calc(50vh - 137px);\n        left: calc(50vw - 137px);\n        width: 275px;\n        height: 275px;\n      }\n\n      h1 {\n        font-size: 1.5rem;\n      }\n\n      .success-inner svg {\n        width: 4rem;\n        height: 4rem;\n        stroke-width: 1;\n      }\n    }\n  </style>\n</head>\n\n<body>\n  <div class=\"header\">\n    <svg width=\"172\" height=\"30\" viewBox=\"0 0 172 30\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n      <path\n        d=\"M29.5851 14.7202L27.2892 14.7286V14.7872C27.1552 18.2143 25.8816 21.0967 23.527 23.359C22.4126 24.4483 21.1055 25.303 19.6643 25.8811C18.2231 26.4593 16.6813 26.7442 15.1312 26.7274H14.6117C8.73797 26.5096 3.91162 22.01 3.11561 16.0274C2.73855 13.2958 3.3586 10.5223 4.86684 8.21805C7.18784 4.60667 10.5814 2.67948 14.9804 2.46163H15.039V0.18252L14.9888 0.174141C14.8296 0.149004 14.662 0.140625 14.4944 0.140625C13.0281 0.140625 10.64 0.72716 9.048 1.49803C6.24938 2.78841 3.94514 4.93345 2.46204 7.63152C0.962188 10.3212 0.375653 13.4298 0.786227 16.4798C1.08787 18.7589 1.92578 20.9291 3.22454 22.8228C4.52329 24.7164 6.25776 26.2666 8.2855 27.3559C10.3132 28.4368 12.5672 29.0317 14.8631 29.0736C17.1589 29.1155 19.438 28.6127 21.4993 27.5989C27.2222 24.7835 29.6773 19.1611 29.5851 14.7789V14.7202Z\"\n        fill=\"white\" />\n      <path\n        d=\"M22.6721 14.4688V14.4101C22.7224 12.1729 21.3985 9.18996 18.3485 7.76551C17.3514 7.30467 16.2621 7.06167 15.1645 7.06167C13.849 7.05329 12.5586 7.39684 11.4107 8.0504C10.2627 8.70397 9.31589 9.64243 8.63718 10.782C7.96686 11.9215 7.61494 13.2119 7.59818 14.5274C7.5898 15.8429 7.91658 17.1417 8.56177 18.2896C10.0281 20.9123 12.7848 22.1021 14.7372 22.1021H15.0472V19.8314L14.9885 19.823C11.6788 19.5549 9.92756 16.9155 9.9527 14.5526C9.96108 13.2957 10.4303 12.0975 11.2598 11.1507C12.0894 10.2038 13.2373 9.60053 14.4858 9.44971C14.712 9.42457 14.9466 9.40781 15.1729 9.40781C16.1784 9.39943 17.1671 9.70108 17.9966 10.2709C18.6921 10.7233 19.2619 11.335 19.6724 12.0556C20.083 12.7762 20.3176 13.5806 20.3511 14.4101V14.4688H22.6721Z\"\n        fill=\"white\" />\n      <path\n        d=\"M12.6592 14.5026C12.6592 15.8097 13.7149 16.8655 15.0221 16.8655C16.3292 16.8655 17.385 15.8097 17.385 14.5026C17.385 13.1955 16.3292 12.1313 15.0221 12.1397C13.7149 12.1397 12.6592 13.1955 12.6592 14.5026Z\"\n        fill=\"white\" />\n      <path\n        d=\"M7.56568 6.72676L8.47062 7.53953L9.28339 8.27689L9.32529 8.23499C10.5654 7.10382 12.1071 6.36646 13.7662 6.10671C15.4169 5.84696 17.1178 6.08157 18.6428 6.77703C20.1678 7.4725 21.4582 8.60367 22.3547 10.0197C23.2429 11.4358 23.7038 13.0865 23.6703 14.7623C23.6367 16.4465 23.1089 18.072 22.162 19.4546C21.2152 20.8371 19.8745 21.9096 18.3244 22.5381C16.7743 23.1749 15.065 23.3341 13.4227 23.0073C11.7804 22.6805 10.2721 21.8845 9.07391 20.7031L9.03202 20.6612L7.82543 21.9767L7.47351 22.3705L7.51541 22.4124C9.37556 24.3731 12.1993 25.5462 15.1236 25.5462C18.0311 25.5462 20.813 24.3982 22.8659 22.3537C24.9187 20.3092 26.0834 17.5358 26.0834 14.6282C26.0834 11.7207 24.9355 8.93884 22.891 6.88596C20.8465 4.83309 18.0647 3.67678 15.1655 3.6684C12.3585 3.64326 9.65207 4.72416 7.61595 6.68486L7.56568 6.72676Z\"\n        fill=\"white\" />\n      <path d=\"M79.0978 19.0106V19.0606H79.1478H86.2284V21.4408H76.1059V7.52266H79.0978V19.0106Z\" fill=\"white\" />\n      <path d=\" M62.4567 18.4158H62.4232L62.4105 18.4467L61.1664 21.4658H58.1264L64.3326 7.54756H67.3847L73.6076\n        21.4658H70.4922L69.2481 18.4467L69.2353 18.4158H69.2019H62.4567ZM63.3908 16.1592L63.3623\n        16.2283H63.4371H68.255H68.3299L68.3012 16.1591L65.888 10.3357L65.8418 10.224L65.7956 10.3357L63.3908 16.1592Z\"\n        fill=\"white\" />\n      <path\n        d=\"M55.6526 21.4574H52.8702L52.8452 12.7009L52.8447 12.5201L52.7522 12.6755L48.9986 18.9846L48.9984 18.9849L47.7592 21.034L47.1908 20.0995L47.1241 19.9828L47.1241 19.9828L47.1234 19.9816L42.7914 12.8678L42.6987 12.7155V12.8938V21.4658H39.9163V7.53926H42.3936L47.7668 16.4555L47.81 16.5272L47.8526 16.4552L53.1421 7.53926H55.611L55.6526 21.4574Z\"\n        fill=\"white\" />\n      <path\n        d=\"M91.0203 9.94407V9.89407H90.9703H86.4704V7.51387H98.5536V9.89407H94.0537H94.0037V9.94407V21.4404H91.0203V9.94407Z\"\n        fill=\"white\" />\n      <path\n        d=\"M144.662 10.7998L144.662 10.7999C145.319 11.8808 145.652 13.1034 145.652 14.4775C145.652 15.8517 145.328 17.0826 144.662 18.1801C143.997 19.2617 143.09 20.1186 141.933 20.7429C140.776 21.3671 139.477 21.6837 138.019 21.6837C136.568 21.6837 135.253 21.3671 134.087 20.7429C132.93 20.1186 132.024 19.2701 131.358 18.1804C130.71 17.0827 130.385 15.8433 130.385 14.4775C130.385 13.1117 130.71 11.889 131.358 10.7997C132.024 9.70141 132.93 8.8363 134.087 8.2121C135.261 7.58784 136.568 7.27119 138.019 7.27119C139.477 7.27119 140.776 7.58788 141.933 8.21203C143.09 8.83626 143.997 9.70146 144.662 10.7998ZM140.372 18.5934L140.372 18.5934L140.373 18.593C141.076 18.1862 141.627 17.6183 142.017 16.9067C142.424 16.1946 142.627 15.3816 142.627 14.4775C142.627 13.5732 142.424 12.7686 142.017 12.0484C141.627 11.3367 141.076 10.7769 140.373 10.3869C139.669 9.98012 138.881 9.77708 138.019 9.77708C137.156 9.77708 136.368 9.98014 135.664 10.3869C134.97 10.7768 134.41 11.328 134.003 12.0481L134.003 12.0483C133.605 12.7605 133.41 13.5736 133.41 14.4775C133.41 15.3819 133.613 16.1861 134.003 16.9061L134.003 16.9061L134.003 16.9068C134.41 17.6267 134.961 18.1862 135.664 18.593L135.665 18.5934C136.368 18.9833 137.156 19.1779 138.019 19.1779C138.889 19.1779 139.669 18.9833 140.372 18.5934Z\"\n        fill=\"white\" />\n      <path\n        d=\"M104.536 15.5085H104.486V15.5585V19.0525V19.1025H104.536H112.229V21.4408H101.52V7.52266H111.969V9.86097H104.536H104.486V9.91097V13.2039V13.2539H104.536H110.603V15.5085H104.536Z\"\n        fill=\"white\" />\n      <path\n        d=\"M118.226 20.7236L118.226 20.7235C117.153 20.1665 116.305 19.3603 115.665 18.3037C115.025 17.2398 114.708 16.0865 114.708 14.6032C114.708 13.1782 115.033 11.9137 115.682 10.8162C116.347 9.70149 117.262 8.83639 118.427 8.21214C119.601 7.5879 120.917 7.27119 122.384 7.27119C123.61 7.27119 124.718 7.47963 125.725 7.88752C126.675 8.28044 127.47 8.83398 128.129 9.56401L126.232 11.316C125.207 10.2823 123.974 9.7687 122.543 9.7687C121.614 9.7687 120.784 9.97148 120.056 10.3782C119.327 10.7765 118.759 11.3362 118.352 12.0651C117.945 12.7941 117.742 13.6322 117.742 14.578C117.742 15.5658 117.928 16.2928 118.327 16.9968L118.327 16.9972C118.734 17.7002 119.277 18.2349 119.955 18.5999L119.956 18.6002C120.558 18.9137 121.21 19.083 121.904 19.1169L121.904 19.1169H121.906H124.923H124.973V19.0669V15.3045H127.671V21.5642H127.669H127.665H127.662H127.658H127.653H127.649H127.645H127.64H127.636H127.631H127.626H127.621H127.616H127.611H127.606H127.601H127.595H127.589H127.584H127.578H127.572H127.566H127.56H127.553H127.547H127.54H127.534H127.527H127.52H127.513H127.506H127.499H127.492H127.484H127.477H127.469H127.461H127.454H127.446H127.438H127.43H127.421H127.413H127.405H127.396H127.387H127.379H127.37H127.361H127.352H127.343H127.334H127.324H127.315H127.305H127.296H127.286H127.276H127.266H127.257H127.246H127.236H127.226H127.216H127.205H127.195H127.184H127.174H127.163H127.152H127.141H127.13H127.119H127.108H127.096H127.085H127.074H127.062H127.05H127.039H127.027H127.015H127.003H126.991H126.979H126.967H126.955H126.942H126.93H126.917H126.905H126.892H126.88H126.867H126.854H126.841H126.828H126.815H126.802H126.789H126.775H126.762H126.749H126.735H126.722H126.708H126.694H126.68H126.667H126.653H126.639H126.625H126.611H126.597H126.582H126.568H126.554H126.539H126.525H126.51H126.496H126.481H126.467H126.452H126.437H126.422H126.407H126.392H126.377H126.362H126.347H126.332H126.317H126.301H126.286H126.271H126.255H126.24H126.224H126.209H126.193H126.177H126.161H126.146H126.13H126.114H126.098H126.082H126.066H126.05H126.034H126.018H126.002H125.985H125.969H125.953H125.936H125.92H125.904H125.887H125.871H125.854H125.838H125.821H125.804H125.788H125.771H125.754H125.737H125.721H125.704H125.687H125.67H125.653H125.636H125.619H125.602H125.585H125.568H125.551H125.534H125.516H125.499H125.482H125.465H125.448H125.43H125.413H125.396H125.378H125.361H125.343H125.326H125.309H125.291H125.274H125.256H125.239H125.221H125.203H125.186H125.168H125.151H125.133H125.115H125.098H125.08H125.062H125.045H125.027H125.009H124.992H124.974H124.956H124.938H124.921H124.903H124.885H124.867H124.85H124.832H124.814H124.796H124.778H124.761H124.743H124.725H124.707H124.689H124.672H124.654H124.636H124.618H124.6H124.583H124.565H124.547H124.529H124.511H124.494H124.476H124.458H124.44H124.423H124.405H124.387H124.369H124.352H124.334H124.316H124.298H124.281H124.263H124.245H124.228H124.21H124.192H124.175H124.157H124.14H124.122H124.105H124.087H124.07H124.052H124.035H124.017H124H123.982H123.965H123.947H123.93H123.913H123.895H123.878H123.861H123.844H123.827H123.809H123.792H123.775H123.758H123.741H123.724H123.707H123.69H123.673H123.656H123.639H123.622H123.605H123.589H123.572H123.555H123.538H123.522H123.505H123.488H123.472H123.455H123.439H123.422H123.406H123.39H123.373H123.357H123.341H123.325H123.308H123.292H123.276H123.26H123.244H123.228H123.212H123.196H123.181H123.165H123.149H123.134H123.118H123.102H123.087H123.071H123.056H123.041H123.025H123.01H122.995H122.98H122.964H122.949H122.934H122.919H122.905H122.89H122.875H122.86H122.846H122.831H122.816H122.802H122.788H122.773H122.759H122.745H122.73H122.716H122.702H122.688H122.674H122.661H122.647H122.633H122.619H122.606H122.592H122.579H122.565H122.552H122.539H122.526H122.513H122.5H122.487H122.474H122.461H122.448H122.435H122.423H122.41H122.398H122.386H122.373H122.361H122.349H122.337H122.325H122.313H122.301H122.289H122.278H122.266H122.255H122.243H122.232H122.221H122.21H122.198H122.187H122.177H122.166H122.155H122.144H122.134H122.123H122.113H122.103H122.092H122.082H122.072H122.062H122.053H122.043H122.033H122.024H122.014H122.005H121.996H121.986H121.977H121.968H121.959H121.951H121.942H121.933H121.925H121.917H121.908H121.9H121.892H121.884H121.876H121.868H121.861H121.853H121.846H121.838H121.831H121.824H121.817H121.81H121.803H121.797H121.79H121.784H121.777H121.771H121.765H121.759H121.753H121.747H121.741H121.736H121.73H121.725H121.72H121.715H121.71H121.705H121.7H121.695H121.691H121.686H121.682H121.678H121.674H121.67H121.666H121.663H121.659H121.656H121.652H121.649H121.646H121.643H121.64H121.638H121.635H121.633H121.63H121.628H121.626H121.624H121.623H121.621H121.619H121.618H121.617H121.616H121.615H121.614H121.613H121.613H121.612C121.583 21.5642 121.532 21.5621 121.487 21.56L121.43 21.5572L121.413 21.5562L121.408 21.556L121.407 21.5559L121.407 21.5559L121.407 21.5559L121.406 21.5559L121.406 21.5559L121.299 21.5476L121.299 21.5476L121.297 21.5475C120.19 21.4892 119.166 21.2145 118.226 20.7236Z\"\n        fill=\"white\" />\n    </svg>\n  </div>\n  <div class=\"success-wrapper\">\n    <div class=\"success-inner\">\n      <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\" fill=\"none\" stroke=\"#CE3737\"\n        stroke-width=\"0.5\" stroke-linecap=\"round\" stroke-linejoin=\"round\" class=\"feather feather-x\">\n        <line x1=\"18\" y1=\"6\" x2=\"6\" y2=\"18\" />\n        <line x1=\"6\" y1=\"6\" x2=\"18\" y2=\"18\" />\n      </svg>\n      <h1>\n        Authentication failed\n      </h1>\n      <p>\n        Please check your credentials and try to Login again through your Maltego application.\n        <br />\n        <br />\n        If this problem persists contact:\n        <a href=\"mailto:support@maltego.com\">support@maltego.com</a>\n      </p>\n    </div>\n  </div>\n  <footer>\n    <div>\n      Copyright 2023 Maltego Technologies GmbH\n    </div>\n    <div class=\"footer-links\">\n      <a href=\"https://www.maltego.com/legal-notice/\" target=\"_blank\">\n        Legal Notice\n      </a>\n      <a href=\"https://www.maltego.com/data-privacy/\" target=\"_blank\">\n        Data Privacy\n      </a>\n      <a href=\"https://www.maltego.com/license-agreement/\" tarket=\"_blank\">\n        License Agreement\n      </a>\n    </div>\n  </footer>\n</body>\n\n</html>";
    }
}

