/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.imgfactoryapi.IconCatalog;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.WrappedRegistryIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;

public class MemoryIconRegistry
extends IconRegistry {
    private final Map<String, Map<String, Image>> _icons;
    private final IconCatalog _catalog;
    private final PropertyChangeSupport _support = new PropertyChangeSupport(this);

    public MemoryIconRegistry() {
        this._icons = new HashMap<String, Map<String, Image>>();
        this._catalog = new IconCatalog();
    }

    @Override
    public RegistryIcon addFromImages(String category, String iconName, Map<IconSize, Image> iconImages) throws IOException {
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(category);
        iconImages.forEach((size, image) -> categoryIconsMap.put(iconName + size.getPostfix(), (Image)image));
        RegistryIcon icon = this._catalog.addOrReplaceIcon(category, iconName, Collections.emptySet(), Collections.emptySet());
        this._support.firePropertyChange("addedIcon", null, icon);
        return icon;
    }

    @Override
    public RegistryIcon addFromFiles(String category, String iconName, Map<IconSize, FileObject> iconFiles) throws IOException {
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(category);
        for (Map.Entry<IconSize, FileObject> entry : iconFiles.entrySet()) {
            IconSize size = entry.getKey();
            FileObject imageFile = entry.getValue();
            this.add(categoryIconsMap, iconName + size.getPostfix(), imageFile);
        }
        RegistryIcon icon = this._catalog.addOrReplaceIcon(category, iconName, Collections.emptySet(), Collections.emptySet());
        this._support.firePropertyChange("addedIcon", null, icon);
        return icon;
    }

    private void add(Map<String, Image> categoryIcons, String nameAndSize, FileObject iconFile) throws IOException {
        try (InputStream is = iconFile.getInputStream();){
            BufferedImage image = ImageIO.read(is);
            categoryIcons.put(nameAndSize, image);
        }
    }

    @Override
    protected void removeIcon(RegistryIcon icon) throws IOException {
        String[] names;
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(icon.getCategory());
        for (String name : names = this.getSizeNames(icon.getName())) {
            categoryIconsMap.remove(name);
        }
        this._catalog.removeIcon(icon);
        this._support.firePropertyChange("removedIcon", icon, null);
    }

    @Override
    public void removeCategory(String category) throws IOException {
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(category);
        Set<String> iconNames = this.getIconNames(category);
        if (iconNames != null) {
            for (String iconName : iconNames) {
                for (IconSize iconSize : IconSize.values()) {
                    categoryIconsMap.remove(iconName + iconSize.getPostfix());
                }
            }
        }
        this._catalog.removeCategory(category);
        this._support.firePropertyChange("removedCategory", category, null);
    }

    @Override
    public List<RegistryIcon> getIcons() {
        return this._catalog.getIcons();
    }

    @Override
    public List<RegistryIcon> getIcons(String category) {
        return this._catalog.getIcons(category);
    }

    @Override
    public boolean contains(RegistryIcon icon) {
        return this._catalog.contains(icon);
    }

    @Override
    public Set<String> getCategories() {
        return this._catalog.getCategories();
    }

    @Override
    public Set<String> getIconNames(String category) {
        return this._catalog.getIconNames(category);
    }

    @Override
    public RegistryIcon rename(RegistryIcon icon, String newName) throws IOException {
        String category = icon.getCategory();
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(category);
        for (IconSize size : IconSize.values()) {
            String oldNameAndSize = icon.getName() + size.getPostfix();
            String newNameAndSize = newName + size.getPostfix();
            Image image = categoryIconsMap.remove(oldNameAndSize);
            if (image == null) continue;
            categoryIconsMap.put(newNameAndSize, image);
        }
        RegistryIcon newIcon = this._catalog.rename(icon, newName);
        this._support.firePropertyChange("renamedIcon", icon, newIcon);
        return newIcon;
    }

    @Override
    public void replace(RegistryIcon icon, IconSize size, BufferedImage image) throws IOException {
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(icon.getCategory());
        if (image.getWidth() != size.getSize() || image.getHeight() != size.getSize()) {
            image = ImageUtils.smartSize((BufferedImage)image, (double)size.getSize());
        }
        categoryIconsMap.put(icon.getName() + size.getPostfix(), image);
        this._support.firePropertyChange("replacedIconSize", null, new WrappedRegistryIcon(icon, image));
    }

    private Map<String, Image> getCategoryIconsMap(String iconCategory) {
        Map<String, Image> categoryIcons = this._icons.get(iconCategory);
        if (categoryIcons == null && !StringUtilities.isNullOrEmpty((String)iconCategory)) {
            categoryIcons = new HashMap<String, Image>();
            this._icons.put(iconCategory, categoryIcons);
        }
        return categoryIcons;
    }

    @Override
    public Optional<Image> loadImage(RegistryIcon registryIcon, IconSize size) {
        Args.notNull((Object)registryIcon, (String)"registryIcon");
        Args.notNull((Object)size, (String)"size");
        String iconCategory = registryIcon.getCategory();
        String iconName = registryIcon.getName();
        Map<String, Image> categoryIconsMap = this.getCategoryIconsMap(iconCategory);
        return Optional.ofNullable(categoryIconsMap == null ? null : categoryIconsMap.get(iconName + size.getPostfix()));
    }

    @Override
    public void setAliases(RegistryIcon icon, Set<String> aliases) throws IOException {
        RegistryIcon newIcon = this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasesChanged", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    @Override
    public void addAlias(RegistryIcon icon, String alias) throws IOException {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>(icon.getAliases());
        aliases.add(alias);
        RegistryIcon newIcon = this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasAdded", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    @Override
    public void removeAlias(RegistryIcon icon, String alias) throws IOException {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>(icon.getAliases());
        aliases.remove(alias);
        RegistryIcon newIcon = this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasRemoved", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    @Override
    public void setHubItems(RegistryIcon icon, Set<String> hubitems) throws IOException {
        this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), hubitems, icon.getHubItems());
        this._support.firePropertyChange("hubItemsChanged", null, hubitems);
    }

    @Override
    public void addHubItem(RegistryIcon icon, String hubitem) throws IOException {
        LinkedHashSet<String> hubitems = new LinkedHashSet<String>(icon.getHubItems());
        hubitems.add(hubitem);
        this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), hubitems, icon.getHubItems());
        this._support.firePropertyChange("hubItemAdded", null, hubitem);
    }

    @Override
    public void removeHubItem(RegistryIcon icon, String hubitem) throws IOException {
        LinkedHashSet<String> hubitems = new LinkedHashSet<String>(icon.getHubItems());
        hubitems.remove(hubitem);
        this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), hubitems, icon.getHubItems());
        this._support.firePropertyChange("hubItemRemoved", hubitem, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(listener);
    }
}

