/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core;

import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class SpatialPredicate
implements Serializable {
    private static final Map<String, SpatialPredicate> registry = new HashMap<String, SpatialPredicate>();
    private static final List<SpatialPredicate> list = new ArrayList<SpatialPredicate>();
    public static final SpatialPredicate BBoxIntersects = new SpatialPredicate("BBoxIntersects"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.getBoundingBox().relate(queryShape).intersects();
        }
    };
    public static final SpatialPredicate BBoxWithin = new SpatialPredicate("BBoxWithin"){
        {
            this.register("BBoxCoveredBy");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            Rectangle bbox = indexedShape.getBoundingBox();
            return bbox.relate(queryShape) == SpatialRelation.WITHIN || bbox.equals(queryShape);
        }
    };
    public static final SpatialPredicate Contains = new SpatialPredicate("Contains"){
        {
            this.register("Covers");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.CONTAINS || indexedShape.equals(queryShape);
        }
    };
    public static final SpatialPredicate Intersects = new SpatialPredicate("Intersects"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape).intersects();
        }
    };
    public static final SpatialPredicate IsEqualTo = new SpatialPredicate("Equals"){
        {
            this.register("IsEqualTo");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.equals(queryShape);
        }
    };
    public static final SpatialPredicate IsDisjointTo = new SpatialPredicate("Disjoint"){
        {
            this.register("IsDisjointTo");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return !indexedShape.relate(queryShape).intersects();
        }
    };
    public static final SpatialPredicate IsWithin = new SpatialPredicate("Within"){
        {
            this.register("IsWithin");
            this.register("CoveredBy");
        }

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.WITHIN || indexedShape.equals(queryShape);
        }
    };
    public static final SpatialPredicate Overlaps = new SpatialPredicate("Overlaps"){

        @Override
        public boolean evaluate(Shape indexedShape, Shape queryShape) {
            return indexedShape.relate(queryShape) == SpatialRelation.INTERSECTS;
        }
    };
    private final String name;

    protected SpatialPredicate(String name) {
        this.name = name;
        this.register(name);
        list.add(this);
    }

    protected void register(String name) {
        registry.put(name, this);
        registry.put(name.toUpperCase(Locale.ROOT), this);
    }

    public static SpatialPredicate get(String v) {
        SpatialPredicate op = registry.get(v);
        if (op == null) {
            op = registry.get(v.toUpperCase(Locale.ROOT));
        }
        if (op == null) {
            throw new IllegalArgumentException("Unknown Operation: " + v);
        }
        return op;
    }

    public static List<SpatialPredicate> values() {
        return list;
    }

    public static boolean is(SpatialPredicate op, SpatialPredicate ... tst) {
        for (SpatialPredicate t : tst) {
            if (op != t) continue;
            return true;
        }
        return false;
    }

    public abstract boolean evaluate(Shape var1, Shape var2);

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

