/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import com.paterva.maltego.util.http.HttpNotifier;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.core.ProxySettings;
import org.netbeans.core2.network.proxy.DnsUtils;
import org.netbeans.core2.network.proxy.NetworkProxyReloader;
import org.netbeans.core2.network.proxy.ProxyAutoConfig;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class NbProxySelector2
extends ProxySelector {
    private final ProxySelector original;
    private static final RequestProcessor RP = new RequestProcessor(ProxyAutoConfig.class);
    private static final Logger LOG = Logger.getLogger(NbProxySelector2.class.getName());
    private static Boolean useSystemProxies;
    private static final String DEFAULT_PROXY_SELECTOR_CLASS_NAME = "sun.net.spi.DefaultProxySelector";
    private static final int DNS_TIMEOUT = 10000;
    private final RequestProcessor.Task initTask;
    private static volatile boolean initCompleted;
    private static volatile boolean isFirstTime;
    private static final String NON_PROXY_REGEXP_PATTERN = "localhost|127\\..*|\\[::1\\]|0\\.0\\.0\\.0|\\[::0\\]";
    private final Pattern nonProxyHostsPattern = Pattern.compile("localhost|127\\..*|\\[::1\\]|0\\.0\\.0\\.0|\\[::0\\]");

    public NbProxySelector2() {
        this.original = ProxySelector.getDefault();
        LOG.log(Level.FINE, "java.net.useSystemProxies has been set to {0}", NbProxySelector2.useSystemProxies());
        this.initTask = RP.post(new Runnable(){

            @Override
            public void run() {
                if (NbProxySelector2.this.original == null || NbProxySelector2.this.original.getClass().getName().equals(NbProxySelector2.DEFAULT_PROXY_SELECTOR_CLASS_NAME)) {
                    NetworkProxyReloader.reloadNetworkProxy();
                }
                ProxySettings.addPreferenceChangeListener((PreferenceChangeListener)new ProxySettingsListener());
                NbProxySelector2.this.copySettingsToSystem();
                initCompleted = true;
                LOG.log(Level.FINE, "ProxySelector setup completed");
            }
        });
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (isFirstTime) {
            isFirstTime = false;
            Authenticator customAuthenticator = (Authenticator)Lookup.getDefault().lookup(Authenticator.class);
            if (customAuthenticator != null) {
                LOG.log(Level.FINE, "Custom Authenticator, {0}, was found in Global Lookup and will now be used as Authenticator.", customAuthenticator.getClass().getName());
                Authenticator.setDefault(customAuthenticator);
            }
        }
        if (uri.getScheme().equalsIgnoreCase("socket") && !initCompleted) {
            LOG.log(Level.FINE, "Temporary proxy bypass for {0}", uri);
            return Collections.singletonList(Proxy.NO_PROXY);
        }
        if (!initCompleted) {
            LOG.log(Level.FINE, "First time initialization of ProxySelector necessary for URL = {0}. Waiting (blocking) for init task to complete.", uri);
            this.initTask.waitFinished();
        }
        List<Object> res = new ArrayList();
        int proxyType = ProxySettings.getProxyType();
        switch (proxyType) {
            case 0: {
                res = Collections.singletonList(Proxy.NO_PROXY);
                break;
            }
            case 1: {
                if (NbProxySelector2.useSystemProxies()) {
                    if (this.original == null) break;
                    res = this.original.select(uri);
                    break;
                }
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (NbProxySelector2.dontUseProxy(ProxySettings.getSystemNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                    break;
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String ports = ProxySettings.getSystemHttpPort();
                    if (ports != null && ports.length() > 0 && ProxySettings.getSystemHttpHost().length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(ProxySettings.getSystemHttpHost(), porti));
                        res.add(p);
                    }
                } else {
                    String ports = ProxySettings.getSystemSocksPort();
                    String hosts = ProxySettings.getSystemSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    }
                }
                if (this.original == null) break;
                res.addAll(this.original.select(uri));
                break;
            }
            case 2: {
                String protocol = uri.getScheme();
                assert (protocol != null) : "Invalid scheme of uri " + uri + ". Scheme cannot be null!";
                if (NbProxySelector2.dontUseProxy(ProxySettings.getNonProxyHosts(), uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                    break;
                }
                if (protocol.toLowerCase(Locale.US).startsWith("http")) {
                    String hosts = ProxySettings.getHttpHost();
                    String ports = ProxySettings.getHttpPort();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    } else {
                        LOG.log(Level.FINE, "Incomplete HTTP Proxy [{0}/{1}] found in ProxySelector[Type: {2}] for uri {3}. ", new Object[]{hosts, ports, ProxySettings.getProxyType(), uri});
                        if (this.original != null) {
                            LOG.log(Level.FINEST, "Fallback to the default ProxySelector which returns {0}", this.original.select(uri));
                            res.addAll(this.original.select(uri));
                        }
                    }
                } else {
                    String ports = ProxySettings.getSocksPort();
                    String hosts = ProxySettings.getSocksHost();
                    if (ports != null && ports.length() > 0 && hosts.length() > 0) {
                        int porti = Integer.parseInt(ports);
                        Proxy p = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(hosts, porti));
                        res.add(p);
                    } else {
                        LOG.log(Level.FINE, "Incomplete SOCKS Server [{0}/{1}] found in ProxySelector[Type: {2}] for uri {3}. ", new Object[]{hosts, ports, ProxySettings.getProxyType(), uri});
                        if (this.original != null) {
                            LOG.log(Level.FINEST, "Fallback to the default ProxySelector which returns {0}", this.original.select(uri));
                            res.addAll(this.original.select(uri));
                        }
                    }
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            case 3: {
                if (NbProxySelector2.useSystemProxies()) {
                    if (this.original != null) {
                        res = this.original.select(uri);
                    }
                } else {
                    ProxyAutoConfig pac = ProxyAutoConfig.get(NbProxySelector2.getPacFile());
                    assert (pac != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector2.getPacFile();
                    if (pac.getPacURI().getHost() == null) {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString()});
                        res.addAll(pac.findProxyForURL(uri));
                    } else if (pac.getPacURI().getHost().equals(uri.getHost())) {
                        res.add(Proxy.NO_PROXY);
                    } else {
                        LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString(), pac.getPacURI().getHost()});
                        res.addAll(pac.findProxyForURL(uri));
                    }
                }
                if (this.original != null) {
                    res.addAll(this.original.select(uri));
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            case 4: {
                ProxyAutoConfig pac = ProxyAutoConfig.get(NbProxySelector2.getPacFile());
                assert (pac != null) : "Instance of ProxyAutoConfig found for " + NbProxySelector2.getPacFile();
                if (pac.getPacURI().getHost() == null) {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC LOCAL URI: {2}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString()});
                    res.addAll(pac.findProxyForURL(uri));
                } else if (pac.getPacURI().getHost().equals(uri.getHost())) {
                    res.add(Proxy.NO_PROXY);
                } else {
                    LOG.log(Level.FINEST, "Identifying proxy for URI {0}---{1}, PAC URI: {2}---{3}", new Object[]{uri.toString(), uri.getHost(), pac.getPacURI().toString(), pac.getPacURI().getHost()});
                    res.addAll(pac.findProxyForURL(uri));
                }
                res.add(Proxy.NO_PROXY);
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + proxyType;
                break;
            }
        }
        LOG.log(Level.FINEST, "NbProxySelector[Type: {0}, Use HTTP for all protocols: {1}] returns {2} for URI {3}", new Object[]{ProxySettings.getProxyType(), ProxySettings.useProxyAllProtocols(), res, uri});
        return res;
    }

    @Override
    public void connectFailed(URI arg0, SocketAddress arg1, IOException arg2) {
        InetSocketAddress address;
        String host;
        LOG.log(Level.INFO, "connectionFailed(" + arg0 + ", " + arg1 + ")", arg2);
        if (arg1 instanceof InetSocketAddress && (host = (address = (InetSocketAddress)arg1).getHostString()) != null && (host.equalsIgnoreCase("127.0.0.1") || host.equalsIgnoreCase("localhost") || host.equalsIgnoreCase(ProxySettings.getHttpHost())) && arg2 instanceof ConnectException) {
            HttpNotifier notifier = HttpNotifier.getDefault();
            notifier.show(host);
        }
    }

    private void copySettingsToSystem() {
        String host = null;
        String port = null;
        String nonProxyHosts = null;
        String socksHost = null;
        String socksPort = null;
        String httpsHost = null;
        String httpsPort = null;
        int proxyType = ProxySettings.getProxyType();
        switch (proxyType) {
            case 0: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                nonProxyHosts = null;
                socksHost = null;
                socksPort = null;
                LOG.log(Level.INFO, "Direct connection - No proxy is selected");
                break;
            }
            case 1: {
                host = ProxySettings.getSystemHttpHost();
                port = ProxySettings.getSystemHttpPort();
                httpsHost = ProxySettings.getSystemHttpsHost();
                httpsPort = ProxySettings.getSystemHttpsPort();
                socksHost = ProxySettings.getSystemSocksHost();
                socksPort = ProxySettings.getSystemSocksPort();
                nonProxyHosts = ProxySettings.getSystemNonProxyHosts();
                LOG.log(Level.INFO, "Auto-detect proxy is selected");
                break;
            }
            case 2: {
                host = ProxySettings.getHttpHost();
                port = ProxySettings.getHttpPort();
                httpsHost = ProxySettings.getHttpsHost();
                httpsPort = ProxySettings.getHttpsPort();
                nonProxyHosts = ProxySettings.getNonProxyHosts();
                socksHost = ProxySettings.getSocksHost();
                socksPort = ProxySettings.getSocksPort();
                LOG.log(Level.INFO, "Manual set proxy is selected");
                if (ProxySettings.useAuthentication()) {
                    LOG.log(Level.INFO, "Manual set proxy - with explicit proxy authentication");
                }
                if (!(ProxySettings.useProxyAllProtocols() || socksHost == null || socksHost.isEmpty() || socksHost.equals(host) && socksHost.equals(httpsHost))) {
                    LOG.log(Level.INFO, "Manual set proxy - with unique settings for SOCKS proxy");
                }
                if (ProxySettings.preferHttpProxyForMaltegoIdRequests()) {
                    LOG.log(Level.INFO, "Manual set proxy - Preference for http for Maltego ID auth requests is set");
                    break;
                }
                LOG.log(Level.INFO, "Manual set proxy - Preference for http for Maltego ID auth requests NOT set");
                break;
            }
            case 3: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                nonProxyHosts = null;
                socksHost = null;
                socksPort = null;
                LOG.log(Level.INFO, "Auto-detect PAC proxy is selected");
                break;
            }
            case 4: {
                host = null;
                port = null;
                httpsHost = null;
                httpsPort = null;
                nonProxyHosts = ProxySettings.getNonProxyHosts();
                socksHost = null;
                socksPort = null;
                LOG.log(Level.INFO, "Manual set PAC proxy is selected");
                break;
            }
            default: {
                assert (false) : "Invalid proxy type: " + proxyType;
                LOG.log(Level.WARNING, "Invalid proxy type: {0}", proxyType);
            }
        }
        this.setOrClearProperty("http.proxyHost", host, false);
        this.setOrClearProperty("http.proxyPort", port, true);
        this.setOrClearProperty("http.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("https.proxyHost", httpsHost, false);
        this.setOrClearProperty("https.proxyPort", httpsPort, true);
        this.setOrClearProperty("https.nonProxyHosts", nonProxyHosts, false);
        this.setOrClearProperty("socksProxyHost", socksHost, false);
        this.setOrClearProperty("socksProxyPort", socksPort, true);
        LOG.log(Level.INFO, "Set System''s http.proxyHost/Port/NonProxyHost to {0}/{1}/{2}", new Object[]{host, port, nonProxyHosts});
        LOG.log(Level.INFO, "Set System''s https.proxyHost/Port to {0}/{1}", new Object[]{httpsHost, httpsPort});
        LOG.log(Level.INFO, "Set System''s socksProxyHost/Port to {0}/{1}", new Object[]{socksHost, socksPort});
    }

    private void setOrClearProperty(String key, String value, boolean isInteger) {
        assert (key != null);
        if (value == null || value.length() == 0) {
            System.clearProperty(key);
        } else {
            if (isInteger) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.INFO, nfe.getMessage(), nfe);
                }
            }
            System.setProperty(key, value);
        }
    }

    private static void setProperty(String key, String value) {
        if (value != null) {
            System.setProperty(key, value);
        } else {
            System.clearProperty(key);
        }
    }

    static boolean dontUseProxy(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        if (NbProxySelector2.dontUseIp(nonProxyHosts, host)) {
            return true;
        }
        return NbProxySelector2.dontUseHostName(nonProxyHosts, host);
    }

    private static boolean dontUseHostName(String nonProxyHosts, String host) {
        if (host == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String token = st.nextToken().trim();
            int star = token.indexOf("*");
            if (star == -1) {
                dontUseProxy = token.equals(host);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), host, nonProxyHosts});
                continue;
            }
            String start = token.substring(0, star - 1 < 0 ? 0 : star - 1);
            String end = token.substring(star + 1 > token.length() ? token.length() : star + 1);
            boolean compareStart = star > 0;
            boolean compareEnd = star < token.length() - 1;
            dontUseProxy = compareStart && host.startsWith(start) || compareEnd && host.endsWith(end);
            if (!dontUseProxy) continue;
            LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), host, nonProxyHosts});
        }
        return dontUseProxy;
    }

    private static boolean dontUseIp(String nonProxyHosts, String host) {
        String ip;
        if (host == null) {
            return false;
        }
        InetAddress addr = DnsUtils.dnsResolveWithTimeout(host, 10000);
        String string = ip = addr == null ? null : addr.getHostAddress();
        if (ip == null) {
            return false;
        }
        boolean dontUseProxy = false;
        StringTokenizer st = new StringTokenizer(nonProxyHosts, "|", false);
        while (st.hasMoreTokens() && !dontUseProxy) {
            String nonProxyHost = st.nextToken().trim();
            int star = nonProxyHost.indexOf("*");
            if (star == -1) {
                dontUseProxy = nonProxyHost.equals(ip);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host''s IP {1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), ip, nonProxyHosts});
                continue;
            }
            try {
                dontUseProxy = Pattern.matches(nonProxyHost, ip);
                if (!dontUseProxy) continue;
                LOG.log(Level.FINEST, "NbProxySelector[Type: {0}]. Host''s IP{1} found in nonProxyHosts: {2}", new Object[]{ProxySettings.getProxyType(), ip, nonProxyHosts});
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
        return dontUseProxy;
    }

    static boolean useSystemProxies() {
        if (useSystemProxies == null) {
            String netPropertiesFN = "net.properties";
            String propertyKey = "java.net.useSystemProxies";
            Properties props = new Properties();
            String fname = System.getProperty("java.home");
            if (fname == null) {
                return false;
            }
            try {
                File folder = new File(fname, "lib");
                File netProperties = new File(folder, "net.properties");
                if (!netProperties.exists()) {
                    folder = new File(fname, "conf");
                    netProperties = new File(folder, "net.properties");
                }
                fname = netProperties.getCanonicalPath();
                FileInputStream in = new FileInputStream(fname);
                try (BufferedInputStream bin = new BufferedInputStream(in);){
                    props.load(bin);
                }
                String val = props.getProperty("java.net.useSystemProxies");
                val = System.getProperty("java.net.useSystemProxies", val);
                useSystemProxies = Boolean.valueOf(val);
            }
            catch (Exception e) {
                useSystemProxies = false;
            }
        }
        return useSystemProxies;
    }

    static boolean usePAC() {
        String pacFile = ProxySettings.getSystemPac();
        return pacFile != null;
    }

    private static String getPacFile() {
        return ProxySettings.getSystemPac();
    }

    static {
        initCompleted = false;
        isFirstTime = true;
        NbProxySelector2.setProperty("jdk.http.auth.tunneling.disabledSchemes", ProxySettings.useAuthentication() ? ProxySettings.getDisabledSchemes() : null);
        System.setProperty("polyglot.js.nashorn-compat", "true");
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey().startsWith("proxy") || evt.getKey().startsWith("useProxy")) {
                NbProxySelector2.this.copySettingsToSystem();
            }
        }
    }
}

