/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.editing.controls.DateTimePicker;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateRangePresets;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.FixedDateRange;
import com.paterva.maltego.typing.types.PresetsRelative;
import com.paterva.maltego.util.ui.components.LabelGroupWithBackground;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.JXMonthView;

public class DateRangePickerFixedPopupContent {
    public static final Color TEXT_FIELD_COLOR = UIManager.getLookAndFeelDefaults().getColor("TextField.foreground");
    public static final Color TEXT_FIELD_ERROR_COLOR = UIManager.getLookAndFeelDefaults().getColor("7-dark-red");
    private DateTimePicker _fromDateTimePicker;
    private DateTimePicker _toDateTimePicker;
    private JPanel _fixedDateRangePanel;
    private String _format;
    private DateTimeRangePresetsChangeAction _callBack;
    private DateRange _dateRange;
    private AtomicBoolean _updating = new AtomicBoolean(false);

    public DateRangePickerFixedPopupContent() {
        this(null, null, null);
    }

    public DateRangePickerFixedPopupContent(DateRange dateRange, String format, DateTimeRangePresetsChangeAction cb) {
        this._callBack = cb;
        this._dateRange = dateRange == null ? null : DateRange.createCopy((DateRange)dateRange);
        this._format = format == null ? "yyyy-MM-dd HH:mm:ss.SSS Z" : format;
        this.initComponents(this._dateRange);
    }

    public void setDateTimeRangePresetsChangeActionCallBack(DateTimeRangePresetsChangeAction cb) {
        this._callBack = cb;
    }

    public void setDateRange(DateRange dateRange) {
        if (dateRange != null) {
            DateRange temp1 = DateRange.createCopy((DateRange)dateRange);
            DateRange temp2 = DateRange.createCopy((DateRange)dateRange);
            this._dateRange = temp1;
            DateTime fromDate = dateRange.getFromDate();
            this.setFromDate(fromDate);
            this._updating.set(true);
            if (fromDate != null && fromDate.getDate() != null) {
                this._toDateTimePicker.getMonthView().setLowerBound(this.getFromDate().getDate());
            }
            this._updating.set(false);
            this.setToDate(dateRange.getToDate());
            this._updating.set(true);
            this.updateDateRangeSelection();
            this._dateRange = temp2;
            this._updating.set(false);
            if (this._callBack != null) {
                this._callBack.perform(this._dateRange);
            }
        }
    }

    public DateRange getDateRange() {
        return this._dateRange;
    }

    public JPanel getFixedDateRangePanel() {
        return this._fixedDateRangePanel;
    }

    public void setFormats(String format) {
        if (format != null) {
            this._format = format;
            this._fromDateTimePicker.setFormats(new String[]{this._format});
            this._toDateTimePicker.setFormats(new String[]{this._format});
            if (this._callBack != null) {
                this._callBack.perform(this.getDateRange());
            }
        }
    }

    public void setIsUpdating(boolean state) {
        this._updating.set(state);
    }

    private void initComponents(DateRange dateRange) {
        this._fixedDateRangePanel = new TransparentPanel();
        FixedDateRange initFixedDateRange = DateRangePresets.getPresetDateRange((PresetsRelative)PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME);
        Date fromDate = dateRange == null ? initFixedDateRange.getFromDate().getDate() : dateRange.getFromDate().getDate();
        this._fromDateTimePicker = new DateTimePicker(fromDate);
        JXMonthView fromMv = this._fromDateTimePicker.getMonthView();
        fromMv.setZoomable(true);
        fromMv.setShowingLeadingDays(true);
        fromMv.setShowingTrailingDays(true);
        fromMv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DateRangePickerFixedPopupContent.this._updating.get()) {
                    DateTime toDateTime = DateRangePickerFixedPopupContent.this.getToDate();
                    DateTime fromDateTime = DateRangePickerFixedPopupContent.this.getFromDate();
                    FixedDateRange initFixedDateRange = DateRangePresets.getPresetDateRange((PresetsRelative)PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME);
                    Date toDate = toDateTime == null ? initFixedDateRange.getToDate().getDate() : toDateTime.getDate();
                    Date fromDate = fromDateTime == null ? initFixedDateRange.getFromDate().getDate() : fromDateTime.getDate();
                    DateRangePickerFixedPopupContent.this._toDateTimePicker.getMonthView().setLowerBound(fromDate);
                    if (toDateTime != null && fromDateTime != null && toDate.after(fromDate)) {
                        DateRangePickerFixedPopupContent.this.setToDate(toDate);
                    } else {
                        GregorianCalendar timeCalendar = new GregorianCalendar();
                        GregorianCalendar calendar = new GregorianCalendar();
                        calendar.setTime(fromDate);
                        calendar.set(11, timeCalendar.get(11));
                        calendar.set(12, timeCalendar.get(12));
                        calendar.set(13, timeCalendar.get(13));
                        calendar.set(14, timeCalendar.get(14));
                        DateRangePickerFixedPopupContent.this.setToDate(calendar.getTime());
                    }
                    DateRangePickerFixedPopupContent.this.updateDateRangeSelection();
                }
            }
        });
        this._fromDateTimePicker.setFormats(new String[]{this._format});
        this._fromDateTimePicker.setTimeFormat("HH:mm:ss.SSS");
        this._fromDateTimePicker.getEditor().setEditable(false);
        this._fromDateTimePicker.getEditor().getDocument().addDocumentListener(new FromDocumentListenerImpl());
        Date toDate = dateRange == null ? initFixedDateRange.getToDate().getDate() : dateRange.getToDate().getDate();
        this._toDateTimePicker = new DateTimePicker(toDate);
        JXMonthView toMv = this._toDateTimePicker.getMonthView();
        toMv.setZoomable(true);
        toMv.setShowingLeadingDays(true);
        toMv.setShowingTrailingDays(true);
        toMv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DateRangePickerFixedPopupContent.this._updating.get()) {
                    DateRangePickerFixedPopupContent.this.updateDateRangeSelection();
                }
            }
        });
        this._toDateTimePicker.setFormats(new String[]{this._format});
        this._toDateTimePicker.setTimeFormat("HH:mm:ss.SSS");
        this._toDateTimePicker.getEditor().setEditable(false);
        this._toDateTimePicker.getEditor().getDocument().addDocumentListener(new ToDocumentListenerImpl());
        LabelGroupWithBackground fromLabel = new LabelGroupWithBackground("From");
        LabelGroupWithBackground toLabel = new LabelGroupWithBackground("To");
        this._fixedDateRangePanel.setToolTipText("Fixed Date Range");
        GridBagConstraints gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 18, 1, new Insets(3, 0, 3, 0), 5, 0);
        this._fixedDateRangePanel.add((Component)fromLabel, gbc);
        gbc = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(3, 0, 3, 0), 0, 0);
        this._fixedDateRangePanel.add((Component)((Object)this._fromDateTimePicker), gbc);
        gbc = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.5, 18, 1, new Insets(0, 0, 3, 0), 5, 0);
        this._fixedDateRangePanel.add((Component)toLabel, gbc);
        gbc = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 3, 0), 0, 0);
        this._fixedDateRangePanel.add((Component)((Object)this._toDateTimePicker), gbc);
        LabelGroupWithBackground.groupLabels((LabelGroupWithBackground[])new LabelGroupWithBackground[]{fromLabel, toLabel});
        if (dateRange == null) {
            this.setDateRange(new DateRange(fromDate, toDate));
        }
    }

    private void updateDateRangeSelection() {
        JXMonthView fromMv = this._fromDateTimePicker.getMonthView();
        JXMonthView toMv = this._toDateTimePicker.getMonthView();
        DateTime toDateTime = this.getToDate();
        DateTime fromDateTime = this.getFromDate();
        JFormattedTextField toDateEditor = this._toDateTimePicker.getEditor();
        if (toDateTime != null && fromDateTime != null) {
            Date fromDate;
            Date toDate = toDateTime.getDate();
            if (toDate.before(fromDate = fromDateTime.getDate())) {
                toDateEditor.setForeground(TEXT_FIELD_ERROR_COLOR);
                fromMv.clearFlaggedDates();
                toMv.clearFlaggedDates();
            } else {
                toDateEditor.setForeground(TEXT_FIELD_COLOR);
                GregorianCalendar fromCal = new GregorianCalendar();
                fromCal.setTime(fromDate);
                ArrayList<Date> rangeDates = new ArrayList<Date>();
                while (fromCal.getTime().before(toDate)) {
                    rangeDates.add(fromCal.getTime());
                    ((Calendar)fromCal).add(5, 1);
                }
                rangeDates.add(fromDate);
                rangeDates.add(toDate);
                Date[] dateRangeArray = rangeDates.toArray(new Date[rangeDates.size()]);
                fromMv.setFlaggedDates(dateRangeArray);
                toMv.setFlaggedDates(dateRangeArray);
            }
            if (!this._updating.get()) {
                this._dateRange = new DateRange(fromDateTime, toDateTime, this._dateRange.getRelativeItem(), false);
                if (this._callBack != null) {
                    this._callBack.perform(this._dateRange);
                }
            }
        }
    }

    public boolean isOnSameDay() {
        boolean isOnSameDay = false;
        DateRange dateRange = this.getDateRange();
        DateTime fromDateTime = dateRange.getFromDate();
        DateTime toDateTime = dateRange.getToDate();
        if (toDateTime != null && fromDateTime != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            isOnSameDay = sdf.format(fromDateTime.getDate()).equals(sdf.format(toDateTime.getDate()));
        }
        return isOnSameDay;
    }

    private void setFromDate(DateTime value) {
        Date date = new Date();
        if (value != null) {
            date = value.getDate();
        }
        this._fromDateTimePicker.setDate(date);
    }

    public DateTime getFromDate() {
        Date date = this._fromDateTimePicker.getDate();
        if (date != null) {
            return new DateTime(date);
        }
        return null;
    }

    private boolean isFromDateEmpty() {
        return this._fromDateTimePicker.getDate() == null;
    }

    private void setToDate(Date value) {
        DateTime date = new DateTime();
        if (value != null) {
            date = new DateTime(value);
        }
        this.setToDate(date);
    }

    private void setToDate(DateTime value) {
        Date date = new Date();
        if (value != null) {
            date = value.getDate();
        }
        this._toDateTimePicker.setDate(date);
    }

    public DateTime getToDate() {
        Date date = this._toDateTimePicker.getDate();
        if (date != null) {
            return new DateTime(date);
        }
        return null;
    }

    private boolean isToDateEmpty() {
        return this._toDateTimePicker.getDate() == null;
    }

    private class ToDocumentListenerImpl
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (!DateRangePickerFixedPopupContent.this._updating.get()) {
                DateRangePickerFixedPopupContent.this._dateRange = new DateRange(DateRangePickerFixedPopupContent.this._dateRange.getFromDate(), DateRangePickerFixedPopupContent.this.getToDate(), DateRangePickerFixedPopupContent.this._dateRange.getRelativeItem(), false);
                if (DateRangePickerFixedPopupContent.this._dateRange.isValidRange()) {
                    DateRangePickerFixedPopupContent.this._fromDateTimePicker.getEditor().setForeground(TEXT_FIELD_COLOR);
                    DateRangePickerFixedPopupContent.this._toDateTimePicker.getEditor().setForeground(TEXT_FIELD_COLOR);
                } else {
                    DateRangePickerFixedPopupContent.this._toDateTimePicker.getEditor().setForeground(TEXT_FIELD_ERROR_COLOR);
                }
                if (DateRangePickerFixedPopupContent.this._callBack != null) {
                    DateRangePickerFixedPopupContent.this._callBack.perform(DateRangePickerFixedPopupContent.this._dateRange);
                }
            }
        }
    }

    private class FromDocumentListenerImpl
    implements DocumentListener {
        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            if (!DateRangePickerFixedPopupContent.this._updating.get()) {
                DateRangePickerFixedPopupContent.this._dateRange = new DateRange(DateRangePickerFixedPopupContent.this.getFromDate(), DateRangePickerFixedPopupContent.this._dateRange.getToDate(), DateRangePickerFixedPopupContent.this._dateRange.getRelativeItem(), false);
                if (DateRangePickerFixedPopupContent.this._dateRange.isValidRange()) {
                    DateRangePickerFixedPopupContent.this._fromDateTimePicker.getEditor().setForeground(TEXT_FIELD_COLOR);
                    DateRangePickerFixedPopupContent.this._toDateTimePicker.getEditor().setForeground(TEXT_FIELD_COLOR);
                } else {
                    DateRangePickerFixedPopupContent.this._fromDateTimePicker.getEditor().setForeground(TEXT_FIELD_ERROR_COLOR);
                }
                if (DateRangePickerFixedPopupContent.this._callBack != null) {
                    DateRangePickerFixedPopupContent.this._callBack.perform(DateRangePickerFixedPopupContent.this._dateRange);
                }
            }
        }
    }

    public static abstract class DateTimeRangePresetsChangeAction {
        public abstract void perform(DateRange var1);
    }

    public static class GreyLabel
    extends JLabel {
        public GreyLabel(String text) {
            super(text);
            this.setForeground(new Color(70, 70, 70));
            this.setHorizontalAlignment(0);
        }
    }

    public static class TransparentPanel
    extends JPanel {
        public TransparentPanel() {
            super(new GridBagLayout());
            this.setOpaque(false);
        }
    }
}

