/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.imex;

import com.paterva.maltego.customicons.imex.IconMetadata;
import com.paterva.maltego.customicons.imex.IconRegistryIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import java.awt.Image;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategorizedIcons
extends HashMap<String, Map<String, Map<IconSize, Image>>> {
    private final List<IconMetadata> metadatas;

    public CategorizedIcons(List<IconMetadata> metadatas) {
        Args.notNull(metadatas, (String)"metadatas");
        this.metadatas = metadatas;
    }

    public List<IconMetadata> getMetadatas() {
        return this.metadatas;
    }

    public static CategorizedIcons fromList(List<IconRegistryIcon> iconRegistryIcons, List<IconMetadata> metadatas) {
        Args.notNull(iconRegistryIcons, (String)"iconRegistryIcons");
        Args.notNull(metadatas, (String)"metadatas");
        CategorizedIcons icons = new CategorizedIcons(metadatas);
        for (IconRegistryIcon iconRegistryIcon : iconRegistryIcons) {
            EnumMap<IconSize, Image> iconImages;
            String category = iconRegistryIcon.getCategory();
            String name = iconRegistryIcon.getName();
            HashMap<String, EnumMap<IconSize, Image>> icon = (HashMap<String, EnumMap<IconSize, Image>>)icons.get(category);
            if (icon == null) {
                icon = new HashMap<String, EnumMap<IconSize, Image>>();
                icons.put(category, icon);
            }
            if ((iconImages = (EnumMap<IconSize, Image>)icon.get(name)) == null) {
                iconImages = new EnumMap<IconSize, Image>(IconSize.class);
                icon.put(name, iconImages);
            }
            iconImages.put(iconRegistryIcon.getSize(), iconRegistryIcon.getIcon());
        }
        return icons;
    }

    public List<IconRegistryIcon> toList() {
        ArrayList<IconRegistryIcon> iconRegistryIcons = new ArrayList<IconRegistryIcon>();
        for (Map.Entry categoryEntry : this.entrySet()) {
            String category = (String)categoryEntry.getKey();
            Map names = (Map)categoryEntry.getValue();
            for (Map.Entry nameEntry : names.entrySet()) {
                String name = (String)nameEntry.getKey();
                Map sizes = (Map)nameEntry.getValue();
                for (Map.Entry sizeEntry : sizes.entrySet()) {
                    IconSize size = (IconSize)sizeEntry.getKey();
                    Image image = (Image)sizeEntry.getValue();
                    iconRegistryIcons.add(new IconRegistryIcon(category, name, size, image));
                }
            }
        }
        return iconRegistryIcons;
    }
}

