/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.SchemaProperty;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class SchemaPropertyCollector {
    private final Map<String, List<SchemaProperty>> _schema = new LinkedHashMap<String, List<SchemaProperty>>(16, 0.75f, false);

    public boolean isEmpty() {
        return this._schema.isEmpty();
    }

    public void collect(String field) throws PandoraException {
        this.collect(field, "");
    }

    protected void collect(String field, String prefix) throws PandoraException {
        String fieldName = field.substring(prefix.length());
        if (!fieldName.isEmpty()) {
            TypeConverter converter = TypeConverter.get(fieldName);
            if (converter == null) {
                if (prefix.isEmpty()) {
                    throw new PandoraException(String.format("Could not find a TypeConverter for field: %s.", field));
                }
                throw new PandoraException(String.format("Could not find a TypeConverter for field: %s with prefix: %s.", field, prefix));
            }
            String property = converter.getProperty(fieldName);
            SchemaProperty typedProperty = this.getOrCreateSchemaProperty(property, prefix, converter);
            typedProperty.collect(field);
        }
    }

    private SchemaProperty getOrCreateSchemaProperty(String property, String prefix, TypeConverter converter) throws PandoraException {
        SchemaProperty typedProperty;
        List<SchemaProperty> types = this._schema.get(property);
        if (types == null) {
            types = new ArrayList<SchemaProperty>();
            this._schema.put(property, types);
        }
        if ((typedProperty = this.getTypedProperty(types, converter)) == null) {
            typedProperty = new SchemaProperty(property, prefix, converter);
            types.add(typedProperty);
        }
        return typedProperty;
    }

    private SchemaProperty getTypedProperty(List<SchemaProperty> from, TypeConverter converter) {
        for (SchemaProperty fields : from) {
            if (!fields.getConverter().equals(converter)) continue;
            return fields;
        }
        return null;
    }

    public Set<String> getPropertyNames() {
        return this._schema.keySet();
    }

    public List<SchemaProperty> getSchemaProperties() {
        ArrayList<SchemaProperty> properties = new ArrayList<SchemaProperty>();
        for (List<SchemaProperty> propList : this._schema.values()) {
            properties.addAll(propList);
        }
        return properties;
    }

    public List<SchemaProperty> getSchemaProperties(String property) {
        List<SchemaProperty> result = this._schema.get(property);
        if (result == null) {
            return new ArrayList<SchemaProperty>();
        }
        return this._schema.get(property);
    }

    public SchemaProperty getSchemaProperty(String property, Class type) {
        for (SchemaProperty schemaProperty : this.getSchemaProperties(property)) {
            if (!schemaProperty.getConverter().isApplicable(type)) continue;
            return schemaProperty;
        }
        return null;
    }

    public List<SchemaProperty> getSchemaProperties(Class type) {
        ArrayList<SchemaProperty> properties = new ArrayList<SchemaProperty>();
        for (List<SchemaProperty> propList : this._schema.values()) {
            for (SchemaProperty schemaProperty : propList) {
                if (!schemaProperty.getConverter().isApplicable(type)) continue;
                properties.addAll(propList);
            }
        }
        return properties;
    }

    public List<Class> getTypes(String property) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (SchemaProperty prop : this.getSchemaProperties(property)) {
            types.add(prop.getConverter().getClassType());
        }
        return types;
    }

    public Set<String> getFields() {
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        for (List<SchemaProperty> properties : this._schema.values()) {
            for (SchemaProperty property : properties) {
                all.addAll(property.getFields());
            }
        }
        return all;
    }

    public boolean canReadChildren() {
        return true;
    }
}

