/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import java.io.IOException;
import javax.swing.text.Position;
import org.netbeans.modules.java.source.PositionRefProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EditorSupport;
import org.openide.util.Lookup;

public final class DefaultPositionRefProvider
extends PositionRefProvider {
    private final CloneableEditorSupport ces;
    private final EditorSupport es;
    private final Lookup.Provider lkpProv;

    private DefaultPositionRefProvider(CloneableEditorSupport ces, Lookup.Provider lkpProv) {
        this.ces = ces;
        this.es = null;
        this.lkpProv = lkpProv;
    }

    private DefaultPositionRefProvider(EditorSupport es, Lookup.Provider lkpProv) {
        this.es = es;
        this.ces = null;
        this.lkpProv = lkpProv;
    }

    public Position createPosition(int position, Position.Bias bias) {
        return this.ces != null ? this.ces.createPositionRef(position, bias) : this.es.createPositionRef(position, bias);
    }

    public static final class FactoryImpl
    implements PositionRefProvider.Factory {
        public PositionRefProvider create(FileObject fo) throws IOException {
            DataObject dob = DataObject.find((FileObject)fo);
            Node.Cookie obj = dob.getCookie(OpenCookie.class);
            if (obj instanceof CloneableEditorSupport) {
                return new DefaultPositionRefProvider((CloneableEditorSupport)obj, (Lookup.Provider)dob);
            }
            obj = dob.getCookie(EditorCookie.class);
            if (obj instanceof CloneableEditorSupport) {
                return new DefaultPositionRefProvider((CloneableEditorSupport)obj, (Lookup.Provider)dob);
            }
            EditorSupport es = (EditorSupport)dob.getCookie(EditorSupport.class);
            return es != null ? new DefaultPositionRefProvider(es, (Lookup.Provider)dob) : null;
        }
    }
}

