/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;
import org.jivesoftware.smack.util.Base64;

public class StringUtils {
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final char[] QUOTE_ENCODE;
    private static final char[] APOS_ENCODE;
    private static final char[] AMP_ENCODE;
    private static final char[] LT_ENCODE;
    private static final char[] GT_ENCODE;
    private static MessageDigest digest;
    private static Random randGen;
    private static char[] numbersAndLetters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseXEP0082Date(String dateString) throws ParseException {
        DateFormat dateFormat = XEP_0082_UTC_FORMAT;
        synchronized (dateFormat) {
            return XEP_0082_UTC_FORMAT.parse(dateString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXEP0082Date(Date date) {
        DateFormat dateFormat = XEP_0082_UTC_FORMAT;
        synchronized (dateFormat) {
            return XEP_0082_UTC_FORMAT.format(date);
        }
    }

    public static String parseName(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.lastIndexOf("@");
        if (atIndex <= 0) {
            return "";
        }
        return XMPPAddress.substring(0, atIndex);
    }

    public static String parseServer(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int atIndex = XMPPAddress.lastIndexOf("@");
        if (atIndex + 1 > XMPPAddress.length()) {
            return "";
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex > 0 && slashIndex > atIndex) {
            return XMPPAddress.substring(atIndex + 1, slashIndex);
        }
        return XMPPAddress.substring(atIndex + 1);
    }

    public static String parseResource(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex + 1 > XMPPAddress.length() || slashIndex < 0) {
            return "";
        }
        return XMPPAddress.substring(slashIndex + 1);
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }

    public static String escapeNode(String node) {
        if (node == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(node.length() + 8);
        int n = node.length();
        block11: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            switch (c) {
                case '\"': {
                    buf.append("\\22");
                    continue block11;
                }
                case '&': {
                    buf.append("\\26");
                    continue block11;
                }
                case '\'': {
                    buf.append("\\27");
                    continue block11;
                }
                case '/': {
                    buf.append("\\2f");
                    continue block11;
                }
                case ':': {
                    buf.append("\\3a");
                    continue block11;
                }
                case '<': {
                    buf.append("\\3c");
                    continue block11;
                }
                case '>': {
                    buf.append("\\3e");
                    continue block11;
                }
                case '@': {
                    buf.append("\\40");
                    continue block11;
                }
                case '\\': {
                    buf.append("\\5c");
                    continue block11;
                }
                default: {
                    if (Character.isWhitespace(c)) {
                        buf.append("\\20");
                        continue block11;
                    }
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public static String unescapeNode(String node) {
        if (node == null) {
            return null;
        }
        char[] nodeChars = node.toCharArray();
        StringBuilder buf = new StringBuilder(nodeChars.length);
        int n = nodeChars.length;
        block12: for (int i = 0; i < n; ++i) {
            char c = node.charAt(i);
            if (c == '\\' && i + 2 < n) {
                char c2 = nodeChars[i + 1];
                char c3 = nodeChars[i + 2];
                if (c2 == '2') {
                    switch (c3) {
                        case '0': {
                            buf.append(' ');
                            i += 2;
                            continue block12;
                        }
                        case '2': {
                            buf.append('\"');
                            i += 2;
                            continue block12;
                        }
                        case '6': {
                            buf.append('&');
                            i += 2;
                            continue block12;
                        }
                        case '7': {
                            buf.append('\'');
                            i += 2;
                            continue block12;
                        }
                        case 'f': {
                            buf.append('/');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '3') {
                    switch (c3) {
                        case 'a': {
                            buf.append(':');
                            i += 2;
                            continue block12;
                        }
                        case 'c': {
                            buf.append('<');
                            i += 2;
                            continue block12;
                        }
                        case 'e': {
                            buf.append('>');
                            i += 2;
                            continue block12;
                        }
                    }
                } else if (c2 == '4') {
                    if (c3 == '0') {
                        buf.append("@");
                        i += 2;
                        continue;
                    }
                } else if (c2 == '5' && c3 == 'c') {
                    buf.append("\\");
                    i += 2;
                    continue;
                }
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public static String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '>') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(GT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                if (len > i + 5 && input[i + 1] == '#' && Character.isDigit(input[i + 2]) && Character.isDigit(input[i + 3]) && Character.isDigit(input[i + 4]) && input[i + 5] == ';') continue;
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch == '\"') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(QUOTE_ENCODE);
                continue;
            }
            if (ch != '\'') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(APOS_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static synchronized String hash(String data) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
            }
        }
        try {
            digest.update(data.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        return StringUtils.encodeHex(digest.digest());
    }

    public static String encodeHex(byte[] bytes) {
        StringBuilder hex = new StringBuilder(bytes.length * 2);
        for (byte aByte : bytes) {
            if ((aByte & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toString(aByte & 0xFF, 16));
        }
        return hex.toString();
    }

    public static String encodeBase64(String data) {
        byte[] bytes = null;
        try {
            bytes = data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        return StringUtils.encodeBase64(bytes);
    }

    public static String encodeBase64(byte[] data) {
        return StringUtils.encodeBase64(data, false);
    }

    public static String encodeBase64(byte[] data, boolean lineBreaks) {
        return StringUtils.encodeBase64(data, 0, data.length, lineBreaks);
    }

    public static String encodeBase64(byte[] data, int offset, int len, boolean lineBreaks) {
        return Base64.encodeBytes(data, offset, len, lineBreaks ? 0 : 8);
    }

    public static byte[] decodeBase64(String data) {
        return Base64.decode(data);
    }

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    private StringUtils() {
    }

    static {
        XEP_0082_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        QUOTE_ENCODE = "&quot;".toCharArray();
        APOS_ENCODE = "&apos;".toCharArray();
        AMP_ENCODE = "&amp;".toCharArray();
        LT_ENCODE = "&lt;".toCharArray();
        GT_ENCODE = "&gt;".toCharArray();
        digest = null;
        randGen = new Random();
        numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }
}

