// Copyright (C) 2025 EDF
// All Rights Reserved
// This code is published under the GNU Lesser General Public License (GNU LGPL)
#ifndef DYNAMICPROGRAMMINGBYREGRESSIONCUTGRIDADAPT1D_H
#define DYNAMICPROGRAMMINGBYREGRESSIONCUTGRIDADAPT1D_H
#include <fstream>
#include <memory>
#include <functional>
#ifdef USE_MPI
#include <boost/mpi.hpp>
#endif
#include <Eigen/Dense>
#include "StOpt/core/grids/GridAdapt1D.h"
#include "StOpt/dp/OptimizerDPCutGridAdaptBase.h"

/* \file DynamicProgrammingByRegressionCutGridAdapt1D.h
 * \brief Defines a simple  programm  showing how to optimize a problem by dynamic programming where transitional problems are solved using a LP :
 *        Special case with a 1D adaptive grid, and non concavity of VB
 * \author Pierre Gruet
 */

/// \brief Principal function to optimize  a probleme
/// \param p_grid              vector of grid per time step used for  deterministic state (stocks for example)
/// \param p_optimize          optimizer defining the optimisation between two time steps
/// \param p_regressor         regressor object
/// \param p_fileToDump        file to dump continuation values
/// \param p_world             MPI communicator
double  DynamicProgrammingByRegressionCutGridAdapt1D(std::vector<std::shared_ptr<StOpt::GridAdaptBase> >  &p_grids,
        const std::shared_ptr<StOpt::OptimizerDPCutGridAdaptBase > &p_optimize,
        const std::shared_ptr<StOpt::BaseRegression> &p_regressor,
        const std::string   &p_fileToDump
#ifdef USE_MPI
        , const boost::mpi::communicator &p_world
#endif
                                                    );

#endif /* DYNAMICPROGRAMMINGBYREGRESSIONCUTGRIDADAPT1D_H */
