#! /bin/sh

# CVE-2019-8356
# An issue was discovered in SoX 14.4.2. lsx_make_lpf in effect_i_dsp.c allows
# a NULL pointer dereference.
#
# https://sourceforge.net/p/sox/bugs/318
# In effect_i_dsp.c line 367, there is no check for when "h" is NULL,
# resulting in segmentation fault when "h" is dereferenced (array accessing).
# Attached is a sample of the input file. 

# 14.4.2 and Debian:
# Segmentation fault (core dumped)

# 42b355:
# /home/martin/SoX/sox-code/src/.libs/sox FAIL xmalloc: out of memory
# and exits 0

rm -f core out.aiff

${sox:-sox} --single-threaded crash_effect_i_dsp_c_367_segv.mp3 -t aiff out.aiff channels 1 rate 16k fade 3 norm
status=$?

rm -f core out.aiff

case $status in
0) status=255;;
2) status=0;;
esac

exit $status
