# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.purestorageblock import PureStorageBlockMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPureStorageBlockMgmtStoragePoolsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PureStorageBlockMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_get(self, resource_group):
        response = self.client.storage_pools.get(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_create(self, resource_group):
        response = self.client.storage_pools.begin_create(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
            resource={
                "location": "str",
                "id": "str",
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "name": "str",
                "properties": {
                    "availabilityZone": "str",
                    "provisionedBandwidthMbPerSec": 0,
                    "reservationResourceId": "str",
                    "vnetInjection": {"subnetId": "str", "vnetId": "str"},
                    "avs": {"avsEnabled": bool, "sddcResourceId": "str"},
                    "dataRetentionPeriod": 0,
                    "provisionedIops": 0,
                    "provisioningState": "str",
                    "storagePoolInternalId": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_update(self, resource_group):
        response = self.client.storage_pools.begin_update(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
            properties={
                "identity": {
                    "type": "str",
                    "principalId": "str",
                    "tenantId": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "properties": {"provisionedBandwidthMbPerSec": 0},
                "tags": {"str": "str"},
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_delete(self, resource_group):
        response = self.client.storage_pools.begin_delete(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_list_by_resource_group(self, resource_group):
        response = self.client.storage_pools.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_list_by_subscription(self, resource_group):
        response = self.client.storage_pools.list_by_subscription()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_get_health_status(self, resource_group):
        response = self.client.storage_pools.get_health_status(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_get_avs_connection(self, resource_group):
        response = self.client.storage_pools.get_avs_connection(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_get_avs_status(self, resource_group):
        response = self.client.storage_pools.get_avs_status(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_enable_avs_connection(self, resource_group):
        response = self.client.storage_pools.begin_enable_avs_connection(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
            properties={"sddcResourceId": "str"},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_disable_avs_connection(self, resource_group):
        response = self.client.storage_pools.begin_disable_avs_connection(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_finalize_avs_connection(self, resource_group):
        response = self.client.storage_pools.begin_finalize_avs_connection(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
            properties={
                "serviceInitializationData": {
                    "serviceAccountPassword": "str",
                    "serviceAccountUsername": "str",
                    "vSphereCertificate": "str",
                    "vSphereIp": "str",
                },
                "serviceInitializationDataEnc": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_storage_pools_begin_repair_avs_connection(self, resource_group):
        response = self.client.storage_pools.begin_repair_avs_connection(
            resource_group_name=resource_group.name,
            storage_pool_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
