# /*#########################################################################
#
# The PyMca X-Ray Fluorescence Toolkit
#
# Copyright (c) 2004-2014 European Synchrotron Radiation Facility
#
# This file is part of the PyMca X-ray Fluorescence Toolkit developed at
# the ESRF by the Software group.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# ###########################################################################*/
__author__ = "T. Vincent - ESRF Data Analysis"
__contact__ = "thomas.vincent@esrf.fr"
__license__ = "MIT"
__copyright__ = "European Synchrotron Radiation Facility, Grenoble, France"
__doc__ = """
This module provides a standalone Latin-1 monospace font as a texture.
"""


# import ######################################################################

import zlib
from .gl import *  # noqa
from .GLTexture import Texture2D


# Monospace Latin-1 font data #################################################

minChar = 0
maxChar = 255
cExtent, rExtent = 1.001 / 16., 1.001 / 12.
cWidth, cHeight = 8, 15
bearingY = 11

dataWidth = 128
dataHeight = 180
dataMaxValue = 255
dataPixelSize = 1
dataZip = b'x\x9c\xed\x9c\t\\M[\xdb\xc0\x9fsN\xf3\x9c\x06)\xa5\x12\n)I*JQ\xca\x10\x07!\xb3\x0c\xc9\x9cy\xc8\x90\xb8d\xe8\xa6\x90\xcce\xaa\xc4U\x88\xae\xb1L\x99\x85\xa2\x92\xeaFi \xa7\xcc\\\xf7|\xcfZ{\x9f\xce9:\xe4\xbd\xee\xf7\xbe\xdf`\xfd~\x9d\xb5\x87\xb5\xf7\x7f\xef5<\xc3Z\xcf\x0e\xe0g\xfa\x1f\x92\x82Z\xd1l\x9a\xbe\x8f\x03\xdd\xf0\xd03u"y\xab\x91tW\x93\xc3\x14k\xb6`W_\xbaa1\x9a\xbd\xb0\xe36\xf2\xabtN\x89\xdd\x9f\xfe\xddH\xef\xee\x12;\x7f0\xb7\xcd\xb7\xde6\x8dn\x14i\x85\x92\r\xb5\xb9G|\xd5\x81s\xe8|\x862=|%\xb4\xf7P\xe6\xe2\xf3\xec\x85G\xf94\xdb<\x95\xfc\xca\x07\xc8%\xc8\x05\xc8\x7f\x17^\xe1I\xbb\xaf\xf3M\xef@\xba\r@\xe3\xe2\xf0\xfd\x91\xdd\xc1\xf5WX\xd5\x8f\xbe\xe6\'e\xd1\xc3\xb3|\x9bB.\xcd[\x95Pj\xef\xf8\xfb\xf1\xbd\xe8\x81\x08\xd5\x06\xf8cOH\xee\xb1\xfc\xbd\xe6\xb3\x07\x00\xa8\x94\x0b\xde\x96\xffY>\t&\xed\xb1\x9e\x8cG\xf5\xaf\xf4\xbcd\xc0\xf1\xd4\x038\xb1\x80-\xef\x10\xc1\xe4\xf3\xf6\xb0\x07\xcam\xc9o\x8bm\xc5[-\xe8~\x99\xf6\xb7\xf1\xdc\xdc\xae\x92\xbb\x8f{K\x9d\xdd\xd5\xdf5\x05\xb3\x96\x95\xabf\x91\xdd\xf6K\xbd\xe7\xed\xf7W\x826w\x9e\xd9\x81\x8e\x91D\xc1\xd8`v#c8\xfe\xc8G\xe8&\xe8E\xc8\x7f\x0f\x7f\xc0U\xa9\xdd;.\x12;\xaaZ\x85\xe6\xbf\x04\xab\xe1\x96}\xfc\xdb\x93\xd83\xdd\xb7m\xe8\x16h\x0fp\xcb~\xc0#\xf5\t!\x12E\xcf\x8b\xfa\xe1\xfe\x85L\x1eF~V\tIJ\x91(\x17\x10\x16\xd6B\nx\xbd\xbf\xd4\xee`=\x89\x9d\x98\xfc\xda\xac\xf7\xd9\xfb\xc9\xa6\xf5\xb4\xd5\x98\x0fW\x95\xbb6\xe9\xa6\xad\xea;9\xd8\x1c\xbff\xa8D\xd1]K\xd8\x8d\x8b~\xd2\xef\xf7\xc5\xfb\xfb\x06\x055\x93\xdc\xef\x96\xcb\x91:\xef\xa8#\xb97&B\xa9\x94\x9co\xca\xb5\x9e<*\x99\x1ci\xb3\x03f\xfa\xc3\x95\xbe\xa0t\xef\x91\xa2D\xc99\xfb\xd8\x8dJ\xc9\xde,\xc1_\xed&}|\x01\xed\xc8pj\x9c\xf4a\xb6\xff\xb1i\x8fO\xb7\xc3$\x9f\xfc0\xed\xfe-{z\xe8\xf8\x9e\x1bZ\xd0\xfb\x8f\xf8\xcdw\xaa\xdaH\x94l[\xc4\xa3y\xebb9\xe9\x1b\x86\xa9\xd0\x8c+\x9c\xf5\x05(\x9a\xfc\xda\x95*H\x1f\x96~\x7f;eC3\xba\xa118Dt\xac\x05\x19hr={)Z\xb5\x94,\x9a\xcc\xb4\xe3\x96\xc9 3uxc\xf0\x05\x88v\x83\x83se\x17\xaf\x97\xac\xbfr\xdf\xbad\xff\x85\xfc\xfb"M\xfeE\xd6Q\xceH\xf5\xef\xe4\xffL\xff\xa7\xd3\xd0\x98\x99d \xa8{-\x1cBvmCc\xfa\x93\x8e\xe4\x12\xb6c\xb8&Sb0\xd1GmB0\x11y(?y\xc7ZS\xd4>d\x7f>\xee\xeb\x8c\xdb\xd0\x83\x0c<\xe3\xd5[|\xff\x15.\xcfws(\x0e\xe3\xa9\xaf\x16\x16\x12\x012\xeb\xda\xcd\xdf\xc8\xe1K\xab\x03\xcff`\xbeh\xc9\xb8}9T@YW\xe7\x93\x87(`\xf8\x9c\xb3\xa5\xf3\x83]\x19\xfe\x99sx"{\x8b\xdfMTI\x9a\xe5{\x02\xf3\x82\xfe\x05\xbe\xf3\xb1\xb1ao\xb49EC\xc1\xec3U\'\x0b)\x1f_E\xfb\xbd\r-\xc1-\'\xe6\x01\xf7B0\xe5\xff\xce\\\xd6\xa3L,\xfb.\xa3e\xe2\xf0J\x0e|\xf3\xb0\x1a+9\xc0\xffCZ\xa2\xd6%y\xc7\xba\xcd&\x16\xec\x06\x91%\xb9C\xf5\x85\xd6\x00\xaf\xfb\x8a\xf9\x98\xd4?Y\x91\x8c\xe3\xfe\xc1\x04\xb3\x19\xab\x06Q~v\xc8d]\xccW\x1f\xea5\x95U\x14V5(\xe0\xd4_\xd9s\xc3\xb1\x02Gg\x02X\n\x89\x08s~O\xcd&\xb0x\xcf\xc8Yh\xb5\xf6\xd96\xd0\xb2%\xc9\n\xda>=?\\$(\xf8\xcf\x9a\xb4\xfbK/\xcb\xe1N\x80\x14?\xf2\x10\xf9\xf5\x17|\xf2\xc0\xcc\xe4\x81*\xe5{o\x0b\xcb)\xc7z\xda\x97wj]\x19c\xf0\x84o\'\xbfv\xaf\xaa/\xe0\r\x1b\xbf\xd3\x869B"\x97\xdbgQ;\x00L\xb2\xba\xe1\xaf\xf2\xc8\x0by\xc1\xc6x}\x16I\xa9\xd8\xee\xde\teQTS8U\xda\x91G^i\xf8p\x8c$\x7fT\x1e\x15\xc4\n\x86\xe3\xaaP\xef\x9e\xf0\x05\xca\'\xe9\xc1\x1a\xd4\xf6\x85X%\xf4\x01\x15\xaa\x9c\xf1\xd7\xb0tB\xfb\xc4\x03\xb8\xb1\xa1\xecB\xc6G\xf3zU?\xe3\xd3\xfcz\x8db~\xe3\r\xc9~\x9b\x89\xddF\xe8\x00\xbc\x8f^\x12\xfc>\xc5u79>\x1f\xd4\xff\xca\xca*\xfa\x90\xc5XX\xd1\xf1\xa8T\x92\x00\xdc\xaa\xc8\xde\xa0<\xf2;\xee\x1a\x80\xd9\'\xa2\xe9\xb4;9~V\x84/\x93\xc2\x903\x8f\x96\x99K\xbc\xbf\x9c\xcf\xa1\xa7\xeb\xa9\xa9\x9b\xdc\x07\x7f\xae\xcd\x07\xd77jb~\xf7\x12\xda\xf8\x80\xb6\x1b\xefI\x1f\xe0ZZZ\xce(\xb6\x04\xc0;\xf3\x8aB\x01\xbc\xca\xb8\xb0 \x8b\x94\xf8\x9d\x1ab\x1ee\x1cp\x7fF\xed\x1d\xb9\x08jn\x98\x861j^5\x8cQ\x9b\xd0|\xf5\xb3\xd8\xba\xf6oWqv\x08\xab\xf8\xec\x1b\xe3O\x8f\xf7\'\xdf\x93a\xdc%\xbd\xb0*\x1d-\x99\xca\xc2\xf4\xf4t|\xb0\xe2\xe4\xd8\x92\xcb\xcck\xd3\xfaOI\x8b\xad\xb8\x8f\xaf\xc9;\x93\xb3\xbf\x96Xj\xcd>\x1a\x92\x93\x9cK7\xb6\x96`E\xc2\xb1]E\xe49\xf1N\xc2\xce\xf4\xb2&\xc2\xe1\xa2J\x90\xd5\xff\x01\xee\x8f \xbff~v$\xd3u\xc3\x84\x0f\xde\x85\xe4M\x00\x8c\xfa\x8f0a\xcb\xe9\x11\x7f\xa01\xdf\xdf\x93\xeaw\x85\xee\xc3h\x035v`O\xb7\xe8O\xe5T\xab\x11\xde\x1at_\xd3\x8d\xc9{U\xaa\xd5k\r\xa9D\xdf\xff\xbf/-\xfbW\xa4\xd1\xcf\xf4\xff=\xa9\x84\xb8\x93lZ\xc8\x12/*\x9f\x95\'o\x0f\xc3\xf14yY \x1d<\x1d\x88\xbe\x1d\x8f\xa3\x9a\xe4!8\x12\xb8\xa3\xa2\xd7\xa2\xb8u\x19\x86EC\x1a\x01\x87\x1c\xa6\x96\xe2\xbc\x90\x10\xf4d\x8c\x16\xe3fO\x14\xecC\xdc\xe8\xed\xdb\x86\xb4\x06\x988\x03\xado\xd4\xd2]\x06\xe2\x11\xa7_\xd7\xe0\xf5\xbc%W\xafM!\xc0~\x823\xa4\\\xfe\xfeEIU(|T\xef\xfc6*t\x11@N\xc2\xaf\xf9\x87\xd1\xc0\x0ex\xca\xf0\x1b\x0b\xd7S>\xe7D\xba\xffB\x947\x8bP\xa45\x12\xb6@\xfe\xd6\xbfD\xfc|\xf4\xc8\x1c>\xa0(}\x86\x80#!\x94\xef\xf7v3\xe8\xd6\x16\x01\xd4T+\xc3B\x14\xd8N\xefb\x12\x04\xcd\xe1x\xa8f\xa3\xedx_tc^\x93q\x9c?\x08\xe0\xea\x04\xb4\x072\x19\xb1\x9d3\x0cT\x8a\xc7 \xff\x1aSM\x8d\x85\x8c5\xdd\xef)J1\x051\x1fk\xe8OQU\x1eg\xf8\xee\xe5\x1d@\xcc\xbfp\x97\x1b\x98D\xf8\xf7\xfc)\xff\x00Z\xcd\'W\xf7:\x00*#\xbd\xcfbuV\xb6N\x1f\xc2\xf0\x9b<G\xff\xf9\xec\x1c\x10\xf1a]R}\xfe\xb6-\xcc\xfe\xd7\xf9\x9d*\xba\x80\x04\xff\xfcf\xf7s\x83\x08\x7f\xd2\r\xca\xcfG@\xc4\xe9X7\x9d\xbc\xb03O\x00:?\x81`\xe2\xee\xe5W\x96\x08\x83\xf1\xd5\x0bG\x88\xf9sP\xb7\x07|,//_G\xf85\x02\x01\x16<\xbd\x8c\x88LyX\xf4\xa1\xbc\xbcB\x16\xffsU\xa9\x96\x14\xdf5\xf9\x82#\xe1;\\\xefH\xf85\xe8\xe5O\xba\x7f\xc90`1\xe8\x97\x02\xac\xdd\x01\x0e\xd5\xd8\xad\xf2\xc74\xea\x913\x18 o\x8c\x98\xbf\x10\r\xb2\x80\xdb\x06\x06\x06\x1a\x84\xdfRK\x0b\xfb\xc7\xb1\x15\xd0\xe5\x82\xb01,:c``)\x8b\xff\x97O\xea\x1e)>\xa7t\x1a\xc3\x1f\xbb\x8b\xf0\x9f\xe3\x8dg\xdd\xca4\x989\x0b4K\x90\xf7Z \xf8\xcb\x9di\xff\xf9\'\xf0\xfd\x96\x8b\xf9[\xf7\xd6\xaf\xff\rq\xe8\xf2\x10\xbe\x8c\xfa?;\x8f\xb6\xbfqm?I>\xe8+2|\x95\xb2u\xc8\xbf\x8fnsLj\x9c\xab\xd1\xa3\xc0\xc4Rh\xf5N\x19}\xce_\x19~|8\xdasE\xf8\xb2Z\x94\xdf\xa6\xd6\xbd>\xbf}\xb5\xbeL~kT\xd4\x95\xc3\x98\xfe?\xa9\\G\x92\x8f\x9e\x1f\xe5C\xe43\xe4oH\x95S\xbe\x15\xe4\x9b\x00\x86\xf3{L\x80y\xa7I\x99\x02\xe4g\x9d*\xbbi\x8a\xfdq{\xfe\xe6\xb4\xb5\xc8\xbf{[\x80\xa3\x16\x02jQ/\x1f\x11\xf3a\xe9\x1f1\xc7\n\xd4\xea\xf8\xdc\xf4\x9b\xc2\xf4\xdd\xd8V\x85\xdb\xaf\xe7\xaa3|NF\x02\xf2\x8b\xf1\xc2\rR|+!\xf2\xcdJ\xee\xe4gi\xc1\xe9\xc5t\x9cY5\xc7\x1f\x157\x1e8\xb8\xb9h1\x00\xdb\x91>(\x17:vmM\xc5Q\x13\xa2\x97\xd1\xe0\x92w\x13\xb9\xcd\x96C\x89\xa02A\xfbU\xce\r+\x8f\x9c\xef\x88\xcc\x8e#\xa9q\xa7\x8e6:\xe8w\x95\x876\xe4\x84-\xe8\x13\x9bZ\xa3\x13\xca\x1e|8\'b\xe3h\xf7\xed\x89\xfdH!\xec\xfe\x85;_x\xe2?\xd3\xcf\xf4\xefJSC\x96x\xd0\xee7xKp#\xcc\x96\x84\xcciOOX.\xdb2^\x15\xdaQu\x1b\xd2\x82\xaaQ\x9b\xf1\xa0\xb0\x8c8aA\xad\xdbL$e\xda\x06@\x7f2\xf93\xde\x15\xa6\x10c\xbb\xf7@T\xe3$\xf9\xe0\x8eGa.\x0e\xaa\xa6\xb3E\xa4\xe4GQ\xcc\xc6\xf4\x9e\x12\xfc\xdc\x03\xc1gj\xf4\xf1\x96\xaf\x96\xdd\xbc\x87z\xf6\xe3\xa6\x15wQ\xdcC\xff\xa2\xb9\xfe\x89\xed\t\xff\xf65\xc2\xff\r\xe5\xe1(\x94A\xd9\xa8\x17t\xff2q.%\x17\xcfH\x06\xdb\x1a#\xe8\xfc\\\x0f&\xa2\x8f\xa2\xfd\xc2\x91\xe1\xd7\x92)\xc1\xbe\xc4\x8d\x06^A\xdd$k`<\xcd\x82\xaf=q\x92\xe0\xfb\xa1\x0f2\x1b8%#\x80W\x8b\x0f\xf6\xb1#h\xbe\xc5az\xa6n2q\'}l\x11\x7fM,:\x04\xd9\xa0\xfbYAY\x17\xc2Q@m\xd8\xc7\xbb\x83~\x037\xcb\x1f\xd6\xc71W\x8c\xcbU\xaa\xe3\xc3\xc4\xbaIf\x86\xdf\xf7\xb6\x96\xfd#c)\xfe\xf15`\x80~\x18\xdcZB\xf9\xca\xaf<\x01R7)\xcb\xe4\xbb>E\xb1\x8d\xd8\x17\xe6\xcb_\xf3\x92\xc6\xa1\xa0y\xba\x8b\x1a.nO[W1\xa2\xd1\xf0\x05\xb5\x98X\xbebY;I\xbeV<Z\xfd\xdd\x7f\x15\xf3C\xbb\xaf\xfch\t6Bl\xd7\x84\xcd\xc8_=\xeb|\x12\xeaA\xa7l\xc1\xae\x162\xf8r/-\xa1\x00\xfbB\xa6[\xdaM\xeb\xebd\xcax\xaa\x90\xf1w\x93\x9e\xcfcnyt\x1dH\xf0a\xbeh~\x94\xad\x7f\xe9\x94\xfb\xe0L(:@\xad\x85M\xb1\x87\xacF~\xfc\xee\xfc\x1e\xe4\x04\xa7\xdb\xf67\xce\xf5\xf9\x900\xb5Y\r>_\xec\x98\x87\xd3\xc6\x95\xe3\xbb\xf0n\xe6\x84\xd3;9\x7ff\xc4\xe8\xd0\\%)\xbe\xc6s\xd3o\xf1\x99v\xd6\x16b7y\xe0O\xeb\xdf\xb3\x9c\xd5\x00QQb~\x1c\xfa\x9e\xfeh\'\xc1\xc8\x94\xb1h\x0e\xc1\xa2=\xc9vq/qc\xf6E\xbd*kR\x82\xd5\xbfz\xe5\xac\xb3\'\xe2\xc3\xea\x8d\r\xf3\xe1f0\x18\xbd\xef@\xf9p\xf4\x17\x00\xe2&&\xcd\x14\xf3\xd7\xa2n[A\x0c$\xbd\xeaD|L\xf0\xad\x99\xcb{r\x1d\xbd]A[\x98y\x89#\xe6\xc7\xaf\x83/\xf8\x06/t\x1b\xe6\xf7x\x97& \x13\xf7\x84\xdf\xb9\xb6\x11d^\x89\xbe\\\xa0%\xe6[\xbc8\x18\'\xa0o\x96\xf9\x11\xddS\xb0\x16:\xc3\x19\xb4K\xd2\x10\'\x9f\xef_\xc7o-\xbc\x8a\xfav\xbd$\x1fb\x96\x7f\x9d\xef\xa0\xcfn4\x1b^H\xe6\xd9\\\xc9\xb4l\x17=P\xf2\x18\xd5\x9a9\xd1\x8a\xf1\x98\x1b\r\xf4kB7Z\xd2^!\x8f\xb6_KsPt#\x93\xdcf\xa4\x07\xaa\xd1\x81\xaeN\xd4\xad[;)~\xf3\n\xd5\xaf\xf2%\x92Y\\\xfd\xe9\x8b\x1fH\xee\xb9D\xfe\xd1\xe4C&\xd8\x92s\xc3\xff\xc9\xdb\xff`r\x1bC\xd3\x7f\xfa1\xfe\xe3I\xa7\xdf\x7f\xf8\x01\xf6L\x91\xda\xdd\xe1W\xbf\xc8\x9a\xf1\x92{\xea\xeb\x1e$\x88\xf7\x8c\xb3D[\xbcb\x15\xb68\xbdc$\xbbl\xf2\xb0\xf0\xe27\xf9\n\xf1\xa6\x92\xbbG\'\xd4/\xb2Sj\x01\xc9\xef\xa4\x8e\x84\xbdj\xfeB\xb4\xc5\ta\x0f\xf7\xa5\x0b\x89\x07\xd8\xd5@\xf0\xca\x82\xefHZ\x03\xa6\xf7&\xf3[G\'\xf2\xc73\xf3R\xdd\xa6\xf9\x12An5\xc9\x89\xf2U\x06\x07\x92U\'\x03~r\x02\x9f8\x96\xbac\xfb\x1bu |\xdd\xd1\xd4`q\xe4\xf3\xe9:\x98\x05\x9f\xdfR\xc4\xf7l^\xc7\xd7v\x1d\xe8f1\x98\x8bf\xbd\x85\xf3(:1f<v\x94\xae\x98\xbfm\xc7\x92s\x19x\x83\xa3\x85\xa9\xa7J\xf5\xf0m~+]\xb3g>\xca\xc2\xd7\xbb\xef\x14!_\xe7\xe1\x99\xa82\x0f\x94oa7.\x85\x05\xa0V):\x9f\x98w\x12\xf9\xafOo*\r\xc4\x1b\x8c^#\xa4\xb7u\r\xbb\x1b\xcc\xf2\xd7\xa7)\xd7\xf1\x1d_o\xacM;\xb5\x0c\x9d\xb9k\xc7\x93\xaa\xe4Q\x80\xbe<|\xaa\xd4\xb0\x8e\x8f\x12\\\xfe9\xda%G\xd3\x00./@\xfb\xa7\x06\x85\x11\x16K^\x05\xdc\x17\xc8_\x87~\xce\xd8\xcb\xa4dD\x08\xf9\x9dz\x0b \x91\xf0\x85\x1d`<\x9d\xf7\xe4\t\xd9\xf9\xbe\x1d\x0c?xS\x8a\xa2\xb8\xfe\x1d\x0b\xe1\xe68/\xd4\\[\xd1Zx\x84"\xf4\xc0.4r\xc2\xea\xf8m#n\xe7\xbe\xeb\x83||\xc4\xf5\xb1\x00+\xd9\xd9\xe8B<v\x12\xf9\x17\xaf\xc4\xc6&W\x8a\xf9\xdb6\xa0\xcdF\xf8o\xb8\xd0\xb9@\x16\xbf\xf2\xcf~\x12\xed\xefx\x1d\x8e\xf7\xeap\x03\xf9\x088\x8a\x1d\xfa\xf6\x18\x80e\xa9u\xfc\x8bSU\xa0\xa4/\x9eB=\x1b\x81\x8f\x16z\x949\xfe\x18or\n\xf9\x19k\x1c\x1d\x1d\xed\xc5\xfcM\xdbP\x07\x9fd\xfa\x9f\xf3cY\xfc\xc3\xde\xe5\xd4\x1e\xeaq\x97\xf23!\xd9\xcb\xf6\x0e\xf2\xd1JI\xc1\x06\xbc\x85\xcf\x10zL\x84Wy\xa7\r\x1d\x84\x84\x8f\xd5s\x15m\xd6\xde\xaf\xd5\xe9\xa4s\xca\x1a4y\x90\xbf\n\xdb\x05\x14\xc5\xfcQy\x8a\xdc3\xdf\xe4/\x84\xf0\xd3D/\x1b\x08x\xb2\xf8{\xf7\x00\xa4\x8b\x97&\xf7e\xc6\xdc+$\xfc\x87\x19W\n\xc8t\xfa\xae\x971\x07\xb1\xa8\xbd\xe0\xf0\x83G\xc8\xd7\xb8\x9e\x17\x91\x9c \xe6+\xa4\x97\xdc9}B\xcco\x12\xb3U\xb83\xa6\x99\x14_!\x8bZd\xfb\xee\'\xe8\xd5\xe7\xb7\xaa8\x95Y \xb1\xe4\xde\xb1\xbf\x8e\x1d\xba\xebm\x9b\xb8\xfa2\xe6\x8f\xddH\x0f\xf2\xe0&C\xdb\xb4jJ^\xcf}\xb4;\x1d\xe0\xcdM\xe9i^\xa7\x16\xc1\xf8\nJ\x9d\x19\xb7V\x85\xea]\xba\xa6\x9a@\x03A\xacL\xf0\xa1\xa8\xaa\x86\xe6nJ\xa0\xd1\x1e\xdaj\xab\xe1\x80miL xTw@\xdf\x1fY\x82\x1da\xe8\x9c=D\xc6qK\xf7g\xcde\x1c\xfe\xc7\xd3\xa6\xccS\x13e\x1c\xe6\xa5\x1f\xf9Ok\x94\x9f\xe9\x9fL\xf2\xd6\x7f\xf7\xca.\xfb\xd2i~\xb1-\xf9]\x986\xe3o\xdd\xc5\xb8\xf6\xef\xf2\x8fMg\x02B\x1e2\xfe\x99\xe9+Y\xc3\xad\x87\xe1\x88a\xd4\xd3\xb4\xf77s&\x0b\x8f\x9d\x9a\xb5\x9eDf\xe2\x1b\r\x9aJ\xdcd\xcf\xf1o\xf9|3\xbc\x1aeo+\x1b\xb4j\x89L\xed\xabdD]h]7h\x89>\x81|?5\xb0"\x10\xbbV\x00.|>\x9f\x89d\xa9j\x0b\x92|\xb8\xdfE\x06\xbf8o\xd7=\xe2\xbe\xf8\xbf\xda\x9eWI\x1c\xbf\xa3\xf1Oc.\xa0\xbe\xae\x8e\\JD\xee\xdc\xcd\x1f\xc2\xc2\x90\x11\x90\x08\xb0t+@4\xaa\xacN\x85`KUN\xc0\x01h\xfc\x87=\x84\xa1a\xdf-\x1fuh1\n\xa3\xc0\xb0\xb0#/\xe9\xadk,\xa5\xf9w\xba\xc9\xe2\xaf\x00\xde\xcb\xee\x00\x7f\x0c\x83VB\xca\xcf\xa1\x8b\x89\xc3E\xd1ml\xfd\x8b\xf8]\x8a9\xb0a%pkt\x9b\xf6\x81\x9dhc\xb9\xe7\x0fx@\xd6\xe5\x0b:C\xb7\\ZT+\x8fJ\x80\x96\x7f*K\xf3\x0f\xd1\x05K\xfd\x1eX\x9b\xe2P\x9b\xe2^\xa8\xdff\x80\x8a\x10\x8f>\xa7\xfc\xb5\xf4x\xd3\xa7\xe9\xf3te\xf09\xc5N\xdc2\xf4\x8c\xd2z/x\xc2\xcd!\x93\x8a\xbf|b\xfa\xd7\x0e\xd8KCj\xb8\'BH\xb6\xf1\xbdh\xfdM\xc4\xb7z~_\x1blr\x93\x0b\xef%\x8aM\xb2b\xd4\xefgf\x80\x9a\xd0\\\xc4g\r@\xf9~\x89\x0251\x7f<\x9a\x0ek\x91\x0f\xab\xa3\xdc\xc9\xd5KV\xa4\xae\xf7\xa8F{J\xeeB)\xb54\x9bT7\xa9\xa1\x86\xdb/G\xe9\x8c\xaa\xfe\xb4\n\xae4?*\xc9\x8a\x0b:\x8a\xc0\xb1\xe5k\x8a\xf9\xab@\xbe\xc6\r\xeb\x7f\xa4\xa8\xfe\x19>^\xcb\xa1\x01UJ\xb5dZ\n\x9c\x1e\x02\\#|\xeb\xf2\x9dD\xab\xb9g\x1evJG\xfd\x0baG\x8cJ\xe9\njJ:\r\xd3\x1a\xf8\x90Y\xfe\x04\xb9w\xe6\xd2\xfc\xab>P?\x15\xe7\x1czD\xfa\x99\xff\x9b\x9dl\xffc\xf8\x0bRW\x9eH\xa7[[s\xe2\xb0\xe3(\x94\x9d\xbc|\x91\xf0\xe1\xfe\'2{\xa3\xf2i"\xf7\x05*\xda^\xc5\xda\xd0\xb7\x80\xbc\x8f\x8f\x90v\xfb\xb2\x8c\xd8\xd8\x1d\xf4\xc2j+i~\x96T\xb8\x9f\x88\xdf\xa9O/\xda\xe1p\xfc\xdd%\xfc\xb6\x8c\x97\xab\xe4>\xda\x86-\xa2\xdf\x95\x98\x89\x8a|\xabf\xd4\xb0m\xc9\xcc/8j\x80-\xaao[\xa2\xf2\x1d\xc85N\xa5t\xb8wF5\xecJK\xdc\xf0\x94\xe2s\xaa\xa4\xc2\xdfD|[\xf16\xe5\xff\xcd$\xdf\xe1\xc2\xd2/\x0e\xcd\xcc\xdb*\xc1\x1f~#\xe3\xcbkHJ\x10\xaf\x87\xc3\xdeN\x7f\x9foxvu\xbd\xa0S\xf9\xd6\x12|\x93\x06\xa2!\x7f\xa6\xffpb\xe3\x9f\xeb\x84\xa3\xc1\x9c\xad\xe2\xfeh\xb0\x14}A\xce|2#\xa9\xca\x18\xadZ\x93v.$\x0e\xef\xd0\x03Ms%\x03}5C\xa3\xa5\x02)\xbf\x9a"\x93\x93\x17K\xee\xd7\xc5_\xc6\xd0_\xd5\xb7\x11|\t\xbf\xfb"\n\xefa9d\x84\x8df\xbc\xef\xa8\xfd.\xd3\xc9\x93ZtW\xf5#\x87\xcd\xc3v/!]L\xab\xada\x92\r|=\xf1&l\xdf\xe8F6Z\xd9\xda\x9a\xc98\xcf\xe9~y\x08Q\xd4\xfd\xf2\x98}9\xe6\xaf\xc3K=\xc5"\x1a\xae\xcd\xf2\x8f%I\x85{\xba\xecl\xea\xd4;\x11mn\xd5\xe8\xe3\xb7f\xc3W\x13o_`{\xdd9\xb3d\x9c\tc\xcc\xe6\x03\xc57\xa2\x07\x93\xddD\xbak\x9f2l\xd6\xb4U(g26\xcd\xbe\xe1(\xc1\x9fV\x95&\x19\xd7\xb9\xb7\xc3\xa1a\xe3\xb5\xd1)\x1b7\x0f\xd6S\x07\xc4n\x00\xcc\xd5\xaaG\x99\xd85. \xdeee\xcbz\'\xe0\xbe\x1b\xf9\xf5z\xa9J\xeb\xdf19\x9dO\xe5e\xdc\xa6q%\xe8w\xf9\x07UU\xcc\x9d!\xe6\xeb\x15(N~l_w\xb1\xf1\x82\x8dd\x94\xe3\xa5\xd6\x99\xfb3\x08\xdf3\xbbe\xc4A\x1e\x0c\xa3qG{\xeb\nFC\xdc\xb4=\xce\x0ec\xeb\xf3\x8b\xa9zX~\x98i\xff\xd1\xd7\xb2\xc3\xa8\x1fsE\x05\x12L\xd1\xacXp=g\x01U\xe0\xc6\x94\xaa]\xd3\x12\xa6\xc4\xd4]\xdcxy(y|\x14x\xfa.=]P\xa6u*6Z\x1b\x8fJ\xcc\x00\xddV\xc7q$\xd2\x9a\x89\x7f\xde\xc2\x89\xeb\x91\xa6\xe5:\xac>\x9f\xe9\x7f\xcbR\xd8\xfe\xb7\x8e\x9d6\x8f\xdd\x1a\xf0\x14\r\t+\xdb\xbd\xc7l\xa9 c\xfb\x7f\xbf\x92\xe0\x03\x12a\xd0\xfb\xdb\xc6nXj\xbe\x1e\xab=$\x84DR\xa8\x1c\x0b\xb1\xcd\xee\xcc\x9e\xecD\xf8L\xfc\xf3\xa0\x91\xe1\x86.\x0b\xa3\x9b|\x8d\xef!\xd0\x90\xe2\xdb%\r\x9e6a\x15\xd9\xfa\x95]\xdd`\xdb\x1f\x1a\xdf|$\x11qk~\xa0\xa7\xed\x888\x89\x88#\xb9\x9d\xc3M\xb3\xd8}\x9e\xc4\xf1\xe5\x0bZw\x8a\xeeS\x1f/\x1a\x7f;\x9e\xdd\xdd=\x1c \xb9\xa4"=\x9dL\x9cs\xd9\xbfz|\xd0y\xd1Y\xe2r\xa5!\x8b|\xb8R74\x04]Y\x13\xbav\xb3\x03\x9a\xca8\\\x17\xff\xdc\xe1\xbc\x17\xfa\xb9\xce\xc4\x9dm/y\xbe\xb9\xa5\x14\x7f\xd3\xca\xe8\xc7<Y\xf7\xf9\xe1\x14\xf3\xed\xd3,\xdfd\xb0\xd7\x7f\xd3\xb2\xb1\xc6\xb7O\x1b\xdb\x7f\xfb\xfc\xcf\xf4\x0f\'\xe3\x1f0\xcb\xa0Y\xc0`\x9a\x1b\x8c\xf3g\x0e,\x0c\xed,U\xa0\xfd\x86\x91R\xfb\x81[\x99\x19\xe8!;\xe72\xa3V\xe9\xaa\xe4\x87!\xa064$\xc4[\x06H{\xe6\x1af\xc3%\\\xb2|\xdb\x11i4o\xees\x879`k\x9e\xcd.\xf9\x90\xd0-P\xca\xe8x\xc8K\xf2>6\xaa\xa94\xb2\xd1H~\x05\x95\xbf0WjF\xbc\xd3[a\xea\xa4\r2\xf8Z\xce\x8fh\xee\x96j\x99\xe2*q\xbc\x19\xc3\x07%\x96\xdf4*\x91\x15\x13\xc1\xc7\xc9\xe9X\x98\xc4L#-a\x17e\x953\x98\xafk\xc23%\xe7\x91D\xfe\xef~\xa10\xb6\xab,>\x00\xe3\xfdE\xf6\x07\xbe\xe4\xf9/\xf9\x8a\xf6\x99\xac\xc9\xabM9k\xce&1R\xea\x1a\xb3N\xab\xb0\x9fu\x935\x96\x86J\xdcF\xe4\xff\xc55\xc4\x9f2\x1d\x82\x88C\x16\xca\xebH\xc2\x94\xb5\xf9W\xa9w\xa4\xe6\x9aG\xadk\xed\xaeNwX\xf17;\x89f\xb46\xbc\x93\x93\xab\xcf%\x93e\xe1c\x9b\xfc\xa8\xdf4\xb0\xdb\xde12\xf8\xf6\x95"~\xa0\xf4\xe7C\n\xfc\xa7|b\xb7\xe8\x1d\xd9w\x848\xae!G\r/MD\xbd\x10\x14\xb4~\xc2n?0\x08\n\xda0f\xc7DP\x9b2\xc5k\xd8\x16:/yp\xb9\xf8jS>??\x88\xefF\xb8~\x0c\xbf\xeb\x04\x1b\xc9\xc0e\x11\x1f\xe4\x83X\xfe\xe2\x97\xd2|???\xe2\x86\x199z9R\xed6\xff\x84\xca\xe5Q\xe0\xbb\xf7\xb7\xd5=\xd1P\xf1\x8e=\xf2k \xdag]v\x1c\x89\x1a@\x01K\xeeI\xc7\xc7^\xfb\xe2\xf3\x1d\xe9\x14\x80\x95\xb5\x8a\xfa3\x9d\xbeV\xffLrE\xfdK&G\xccn\xf5\xf1\xbb\xd6\x04,\x11\xb2\x1ck\xcaB\x0bV\xae\xbe\xdc\x06L\xb1nFT\xe3y\xef2}\xe9\x0b\xed\xbe\xf9\xb9Z\xc0c\x80s\xdb\xbf\x83/J\x97\x1c\xdb\x9fe$y\x97\xd9\xa2\x96\x9aOGT\xd3\xf5\xc4\x81\x9fq\t\xa0\x91(\xc6\x00\xfa\xa6\x93\xb4\xfd\x1b\xfc\x92\xf43wK\\\xbe\x9fo\x04\xba\x8c~R\x8bUf\xf9mN\x10\x1eg\x97&\xe1\xeb\xbc8u\xa0\xb4\xae\n\x0c\xe9\xf4q\x87o\xf0#]\xfb*\x0ej,\x8b?\xf7\xdbq\xcc\x1dS\x0e>\xa7\x132m\x92\xa99\xaas"\xe1%\xa9\x07\xc5^\xfd\x1b}\xc7{\xd4\xf1E[\xfa\xee\xec\xb46\x9b\xec\xa3F\xd6/.\x95\x14\x18Sz\xdf\xef\xc9\xac\xd9y\xe4\xfb\xb9\xa2\xd4g\xda\xd7\xce\x84\x045\xf4\x9d\xe3\xff\xe84\x9cU\x1b\xe0\xb1\x87J\xa2\xe6iLdi\xe8\xc1\x81\xd4\xec\x0c\xef34\x84\xe4\x8dv\xc7\x9b\xc8\xb8\x1c`\xa5\xc8K\x0bb\xbe\xcc\xf48K\xdd\x1f\x954\x830\xfaaZ\x1f6R\x15\x1c\x0eS\x8f\xc9\xf0D,\x05Ey\x8f\xa2\xfe\xdf\x12Sz\x96\xbb\x96\xe9\r\x0b\x8c\x86u$\xb9\xafn U\x08#\xec\x9c\x07\xd2\xbb\xf7\xb2\x11EVH\'\x85\xf5\x8c\x1ci\xb4\x86\x9a\x83r\xa1\xca\x0b\x88c\xa4\xb0@s(\xbd\x11\xccf\x03\x19V2Fw\x90E?\xea\xd8\x8c\xb6q!\xcf\xa7\x17\xc2\x94b\xe3\x9f\x81\xbb\x845\x8eg\xb3\xab\x1b\x81\xccw\x82=\x8f\xed\xa3\x1bZ$\xc0\x89\xcc\xf8\xf5\xf8u\xcb\x00\x94\xe74\xdeJ\x01\xe4i\x8e\xaf\xb0\x88\xe4\xf8\xe43H\x8e&\xebh\xf6\xc3%_\x927f?\\B\xcd\xe6Br\x14y\x01\x02\xfa\x95\xa5(\xfe\x19\x9c\x04\xf7in.xF\xe5\xafVM\r]WV\xa8\xa9\xa5\xa3upf\xd1!\xc2\x0f)\x98<\xe9(Y\x7f\\E\xf9\xaa\xc2(\x86\xffz\'\xc3/L\x10\xf1\xdf\xc52\xfc\xe7I\x0c\xbf\xf8$\xc3\xcf\xb9@\xf8\xa9\x0b\xaai\xb3\xb0\xf1\xcf\xb0z\xeds\xea\x16\xcf\xdc\x9dK\x15\xd6\xb0\xd4\x0c\xea\x18\xf4\xb8}\x88Z0;F\x9d\'\x06\x81\xf1{F\x8b\x9a\x0b\x99YmU!\xabU_\xb3\xe6Ma\xdd\xd7\xa5/\xdd\x98<\x97\xad\xd0\x0c\xf6\x03\xe9\xa4\x95\xe4\xba\xb7z\x0fI\xc5\x8b\xe2\x9f\xe1\x81\xfbAz\xfe\xbc\xdfF\xba:\x978}1\x9d\xce\xdb\xb4j"\x9d_,1\xa6\xfc\xb1\xac:\xffQ\xfe\x80\x9b\x10E\xd4\xae(\xfe\xb9\xc5k\x85\xf1\xa4!\x1a}\xd0\xe9{\x9fV{\xabN\xb4!J\xba\x9a\xbdA\x7f\xcb\xaa\x00\xce\x0b\xca-`\xc5I\x11\xbf\xa2\xbc\xfc*\xe1W\x95\x97\x93u\xc8\xd7/\xca\xcb\xcb\xb1\xc5\n_bn\xd2 ?\xee\x17\xe8C\xe6\xd2E\xf1\xcf\xb3\x8fA\xb3\x8f\xd8\x10#\xae\x81\xfaGS\xac\xf6b\xe0UcC\xb4\xaf\x95\x87G\xd83gl\x87\xf3\x81\x06<XzZ\xc4\xb700\xd0%|\'\x03\x03\xd2A^\xfb\x18\x18\x18\x90\x00\xee\xb1\x98\xf3\x1a\xe2\xf3\x9e\xbf\x12\xd4\xfc\xd5Z\x1c\xff|\xe1\xad@\xf0\x19\x0b&\xbd\x13\x08>a\xc1M\x1f\x04\x82\x8f\xd8\x10\xcb>\n\x04\x1f\xb6\x01\x9c\xf8\xf4\xfe3\xa9\xff1\x05\xffH\xfd\xbbV\xe0\xa3\xa6\xcd\xaf\x8b\x7f\xd6\xfd\x84\x83t\xdd~P|\x85]s\x0e6D\x89\'\xc0\xc8{\x00\xb7F\x00x=\xe3(\xd6j\x03m\x7f\xcd\x97\xde4>\xfa\x07\xf9\xe4\xd35\x98q\xb9.\xfey4\xa2\xc0\xbdZ\xce\xfb\x19\xe6m>j\xda\xbd\xc56\xd7\xffl\xda\xf4/\x1c:Jo\x1c\xba]\xc7\x9e\xf9 \xdd\x17\xc7k\xc5\x9e\xd8\x1c\xc2\xbf\x88\x8a\xdb\x1c\xf9\xd70G\x05\xfa\xfa6\xe6\x1e\xc8\xcf\xc6|\x10@D\xfa\xa7\xact\x1c\x97K\xd3\xdf\xe6\xa4\xe3\xb8\x9b\x96.x\x94\x8e\xc6\xec\x88\xf4\xca?\xd2=mH\x0f\xd1r\xa9\x8b\x7f\xb6 s\xd6rnJ&t\n\xcbU\xc3\x80:{N\xba:T\xe5uhb\x84#\xda\xc6\xcd\x8dX\x90\x06CRp\x98+Q\xc5\xad\n\\\x9a\xa3\x81\xe5Br\xec\x08\x9dH\xde\x94\x96v#1\xd3\xad\x99r`\xc1\x963!\xf9\x8f|\x81d\xd2\xf1\xf6\x0f\\\xfd\xe3\xc9yU\xe7\x86\x0b\xfd\xafI\xdc]q\x13\xa9"uHb\xdd\xa3\xe6iT\xaf\xa9\xa70\xfe\x89\xff\xd1\x11\xf4\xbb\xf1i\xd3\x9c\xe2d\xde!L\xf4\xb9\xdb\xcc\xf94\xf3:KM\x16\xd5\xb4\xc6\x11\xcc\x7f6`\xf5\xaf\xec\xd4\xa8\x9b\xe9xfUh\x0c\xeb>\xcec\xe6[Fu\xec2\x80\xe4\x83\x94\xc7R\x03\xdd\xcb\xab\xc5$\x99wPZ\xcfX\xb3\xac\x1eV\xf8Ei\x01\x91G\x8a\x0b4G2\xf38+eLz5\r\t\xf6#\xab+j!n\x00t\xc2\xb1\xf7\xe6\x10\xea\x97\xb9E\xfeBG\xb4C\xf8Z\xcam\x1b\x16A\xa7?\xcdWl\x94ZG\xd4^\x143\xb0\xd5\x0c\xb0\x9aN"\xa0\x1a\x81\t\t{\x9ag\x0c:\xe4\x1b\xa5)\x96\xa0\x18\x82Bb\xb4=\xb8\x10\xe5e\x1c,\x0f\xde\xa2\xf0\x80\t\xa7\x0fz\x80\xa30xW\xd5P\xf2\xb1 \xda\xc4qKQ\xdd\xbd[\x95^\xacF\xbeK\x8c8Z\x89\x0fl\xffv\xc7\xbe\xdaV8l\x04\x07\xa3\xdf\xe2\x03\xe8\x97\xa7\xad{\xdfK\x8c\xe7\xde\xb9?\xf9q\x919\x0c, \x11(\x16\xd0\xe5\x15\x1e|\xde\x19Z\n\xb16\x1e\xf4\x07M\xa1)J\x8c@hRc\x8b\xce+\x1a\xb1\x91\xbb\x98\x0b\xed\x1f[\xbb<St\x14\x02x\xbe\xd0D\xfe=g\xca\xbf5\x1b8\x85c\x00N\xae\x05\xb8\x8a\r\x19\x1b\x0b\x90\x82\nj\r\xea\x9b\xed(\xacf\xe1\xa0[I\x84\x95&\xf3\xe7\xf9A\x01"\xaa8\r\xf2a\xc1\x19\xb0\xab\xc0\xba\x88|[~\x83L5\xaf\x88\x02\xaf\x07\xed\t\x1fJ{!\x7f\xd2^\xc2\xe7}\xf6A\x19\xbf\t\xa0\x12;\xe3n\xf4\xb9\xb2\x17!;\x03\xe0,>\xfa,\xf4p\x0f$\xa0\xc9\x88\x9e\x9f\xdb\x03\x03\x98\x97\n\xb0\xf0\x118\xa5\n\x1b~\x7fP|\xdc\xeb,\xf9\xce7r\x9f\x96\xfdI|\x91\x8d+\xbd\xaf\xc8C\xa6\xf0\xead\xb83\x05\xf9zOt\x91\xdf\x84|\xc2\x1by\x08\xe4\x88.Zt\x01\xa0\n\x85\xfd\xb8<\x80\x9c\x19\x00>\x02\xf4\xc1P\x179\x08qD\xcc|\xb0\xfc\x1e\xea\xbd\rg\xd4.\xea|vh\x98\x0f\xfc\xe7\xb7\xc9\xc8"\xf5\xdf\xeb\x15\x17\xf9\xc1\xbfq\xa0\xa7\xd0@\r\xb2\xc7!Wc\xcd|\xe4\xeb\x08Q\x84o;\x00\x9cO=\xb1\x8a\xce\x02\x94a[LEC\xe0\x0e\xb6\xc5\xe0J\xd4U\xd8\x16]?\x93\x1e\x9e\xf2\x99\xc8\xea\xc8\x03;\xbd\xb4\x85\xed\xea\xf1[\xd4\xe3C\xd1(`\xf8\xaa[O\x90\xf7\xd7\xbfy\\\x83\xd4\xbf\xfcKw\xc27\x7f\xbcw)p>\x0c\x06H\x0f\x07x\x8a.R"V\xd3\xad\x15h)c{\x9f@\xdd\x1b\x8c\xca)6\x05{n9\xdegnN\xc8}\x1c_K\x9fm\x84NB}\xf0B\xdbCAh\x00\xb6\xaf\xf1\xdc\xcbvxC\x94\xf5\xb9\x9eX\x91\xe8l_\xa0\x1fs1\xfa/\xf2U\xf1\xcb4g\xc2\x07\xf9-\xe7\x08\x7f~\x9e\x1c\xe1C\xda3\xec\x7f\'\xa3@\xa7\x12Ukl<W=\x7f4\xb6\xfd)y\xa5k\xf3\xd0.\xb9\xa5,w\x02\x9fkD\xa1&g\xcf^l\x7f\x84\xcf\xc4\xf6\xef\xf5gc\x98w\x17\xd5L\x8d2X\xfe\x897\xfa\xac\x03\xba\x9f\x1b\x83\xfc\x9f\xad@\xb9\x06Gn\x95+\xc8\x15{H\xf0\xe3\r\xa8_\x8a|hZ\xeb(<]x\xdf\x06(\xbf\x9f\x10\xf9N5\xe7+Nb\xf5\xb6\xa9\xb8\xfa\xc7\x154\xa3L\x8a\xee>\xcc\xd6A\xaf1\xbb\xe0V1*K\xe5+\xa5\x97*\x89A\xaf\xc6\xfc\x1d>\x9f\x9d\xf2\x9e|\xd0p\xf2Nt1qe\xe2r7\xe7\xee\xc6|mqt\x16\t\xfd\x9fS\xb6%\xf3\x9a\x9c\x04\x9f\x1d\x7f\x1bW\xc6\xaf\xc8\xdc\xa0\xe1\xd6\xc5\x98Xw\nn<\xe0\x91\xef\x7f\xa1\xc9 7\xba\x90\xa9\xdb\xdf\x93N\xafk\xfa\xf4\xa2rX\xd5\xbb\x1fu_\x15\xbb\x0f\x94\x88\xdaR\xf7\xe3\xba\x0f5%[\x9cn\xa3\x98\x89\xd9.\xa3\x18\xbdd?\xaa\x1b\xf3\xff\x03Fz1\xf3\xd4\x0e\xf4:\x0bv\x99\xcd\xc2\xccm\x94%\xfcL\xffk\x92\xaeq\xc3e\xfe\xf5$\x11\xff\xdc\x91\x99\x00sg\xa7\x07\xe5@j^\xa1\xe3\xb1xY\xf1\x13\xd0B<\xd9\xeaM\x9f\x90\xe3+u\x9d\x86o\xdd4\x9e\r\xdbA\xa5\xfeKA]\xfc\xb3e\x16\xed\x9f\xf6\x17OQ\x03dg\xa6/\x8d\xd7?0l\x12\xb5;\x82<\xdb\xca\xf4\xbfU2E\xd3\xcd\xbe\xa7\xe8\xc0\x99|\x96N\xd54\xca\xd5\x8b\xa7\xebc\x1bE\xab\xbc&\xf7\xe9\xf3\xb5\xba\x9cA\xcbm\x08\xeaC\xc2?E\xf1\xcf\xdc}tM\x92\xb3[\x7f\xc2 \x92\x07j-\xa3#\xa5\xbbE\x1b\n\xd0OH\x96\x08U\x90H\x8d\x0f\xb1v\xc7ot\xbaM{\x0f/\x82\\\xa8\xe8\xa7\xe4A/\xe0\xc6\xb2\xfe\xff\x0e&\xd4bK\xb3!\xd4\x91w\xb6n\x86rCo\xc8\xf4\x1e\xa4\x82D\xf1\xcfj>\xd3\xf9\xe4~J\xde\xd3}\xc9\xfd\xe4\xbbM\xf3#\xd3\xa9\xbc.SF\x10C\xc5fZ7\xa3\t\xd4@\xb1\x18\x17@\xdd;\xcf\xa9L\x0b\xb8La\xd6\t:N\xeeK+\xd0:\xd0\x97\xbc\xa79\x9fO\xed\x1e#>\x9f\xbe\xa8.\x9fO\xdfK\x9d\xcf\'\xed\x9d\x14\xbd\xf4*\xf9GC\xa2\xf8\xe7\xb0=\x8b\x8fg\xa1\xdc\x9b\x9b\xb8\xf8\xe0#l\x10\xff\x94%{\xc9\x7f\x84\xe8\xf3\xfb\xb2\x9dO\xd0\x8e\xda\x16\x92\xffl\xf3c\xbc\xc3\xf0W\xfb\xd7\x10G5>wm\x1e\x99\xc8\x8d,^w\x97\xac\\\x05\x97\x85_%\xb1\xc3\x01\x15\x91\xe7.\xe2\x83t\x0e\xfb\x83\xfe\xbb\x0c\x9b\xb0\x874^\xb2y\xd8M\x1a(\xa2\x1f\x96\xb1\th\xdc\xb3\xd6{sq\xfc3\xa9\x8b|>\x93_\n`\xf2\xc3K\x98|\x0b\xb9\x00\x86\xde\x84\xe5CA\xa9z \x8d\x8f\xeeQ\xad\n&\x1f4\xc1\xf6]cP\x7fo\x86\xdb\x96\xc0{\xd1\t4_a\xab\xe5\xd3\x1e{\x9e\xf9w\x1d\x90\xc0\xc6kF\xb2\x81*\xc1\xe4v\x0e\x9b\xef\xe6~\xea(\x8e\x7f6_s=\xf7\x15\xb6\x8fa\xe8\x95\\\x01\xdar\xda\x8b3r\x9fo\xc0n6\xefLn\x05vH\xa3))\xc51\x17V\x82\xd5GfruYqll\xec\xbbv\x10X\x8ey\xb5\'\x0c\xa8\xc1\xbcl8t\xfe\x80\xf9\xe3Y\r\xf19\xb9~\x8a\n\xaf\x1c\xc5\xf1\xcf\x87\x96i\xc0\xcd\t\x00\xd1Q\x8d \x15{\xee\xb2}\xfa\xb0;\n \xf0\x84\x11]\x92\xcf\x9b\xb1\xf8\x8a\x9b\x9b\x05\xb4\xfa\x93\x89gYr\x9e,0\xabB@\x16\xc9\xb5\x80_Br=p\xaau\xc6\xdc\xb0!~\xd3\x1a\x05\xb4A\x1c\xeb\xe2\x9f9/Z\x80\xf1_\xc8\x7f\xd8\x05\xd4\xdf!?} \xc8U"\xff\xe0d\xe0<H\x04\xb3,\x98\x98GZC\xa1b\x04\x8d\x87\xeeV\xabBs\xeb\x8f\xe8\xcb\xc9s\xc0\xe8=\xf6v\xae\x1c\xa8\x0b\xd0\x80\xe2(4X\xff\xa7\xcf\xee\xbc^\xe5(\x8e\x7f\x0e\xbf\xbb\xe9a\xf6\x04b\x14D\xe6\xdd@\xbe\x7fqd\xeee\xe4\xf7)\x8d\xccN\xc7\xf7\xcf\xdf\x92s51\x06\xef\xd4\xaf6u\x13\xe9\x7f\x9b\x9fo\xdd]\x84y\x88`\xf7\xf6\xa7(y\xa6\xd6\xec\xdfR\x84=}\x98\xe0\xf0\xc6\\\x074 bJ\xd3b\xbc\x90\x16S\x90\x11\x83#{z\xcc\xfd\x1b1c\xd1\xcd\x88\xb9\x9e\x1d\x13\x04\x1c\x17\x1f\rG\xd2\x94l\xfc3X\xfb\x1a\xd0\x10\xac\x16\x83MZ\x12}l2\xc4\xc2\x8c\x8cc\x83!\xad\x8d\xf0\xd5T\xf8mT\x07\xf8\x90\x81e8\xf4\x08]1\xb6\x19\xd1\x976\x85\xd5\xb0\x01t\x82\xac\xb9\xdf *A\x8d\x07\r!\x82\xce\x89\xf8\xb98P\xedI\x8evo;\x92\xa3\xe5fI\xf2o\x05\x8a4\x94\x8c;\xde\xfb\x81\xab\x7f<9\xacvm\xb8\xd0\xcf\xf4\xbd\x89\xcb\xe5\x10\xb9/?\xb8.\xa8\x82\xd5\xacvl\x18\xed\x17\xfa\xf8\xcb$\xa1\x87{0\x96\xc2\x00\x95/\x8a\xd8\xc8X\xb9W:\xe9\xefN\x96s\xb9\xa7\xce\x07\xd0\x7f\xa47O\x14~\xa0\x95E\xed\x01\xfd\xabW\xa8_\xbe\xf0\xc68\xba\x92\xb9,\xa4\xfbYY|\xd5LQxo\xff\xdf\xa9\xb9;\xfe\x1c\xfdpP-\xd7(\x81Y\xc1e\xf4\xef\x16Q\xd4|\xd2\xa0\xe9\xa8\xa8\xdb$\xd4n \xc3G\x7f\xa0\xd92\xc6\xae\xfd\x95\r\x93\x0cc\xc2\x17W\xda\xb9\xd2p\xa2Irs)\xc0\xde\xdeH\xa6\x1d\x02\x06"=|\x98Jf\x8d\xbdr\x11\xe4\xdf1\xc9\xfb\xa9z0\x0b\xb9\x8c\xfe\x8d\x13\xfd{LOsk4\x94\xcd\xf4G=\xa6\x9f\x1c6\xf1\x1eL\xcd\x02\xab\xc0!\xb4\xde\xcc\'0\xff\xff\xcb\xc8\x7f4\x1d\xd6\xba#\xc7\xd1a\xad14\x80\xb9]{f\xddA\x8e?\xd5\xbe[_\xe0\xf19\xa0Jf\xee\xfb(\xe1!T\xa4\x9exu\x1f\xbc\x93+^\xed\xa9\rj\xe4\x9c~w\xc2\xef=\x81\x88e\x1flM\xa5~\xe0\xfe<\xa7 \x16w3.\xef?G>o\xed\xfdf\xe7\xed\xbb(O\x9dj\x0f\\,D\x83\xdf\xeaE\xf2\xc9r\xac7\xa3\xb23\x87\xaa\xb1\'h\x14d\xeeyE\r\x92\x05\xef\xc8/\xe7\xcc\x83\xe5O\xae+\x83\xaaP\x0e\x9a\x13\xdf\xeb\xb5\x11\xa8\x11\xdf\xab\x10\x95\xf5[3\x80Ll\xdd"G\xe0=E%\xb7\x1a-\xa9\xb8\xc7\xa7\x8e\x95\xe3\x03\xfc\x8eJn\xe8%\xce\xe3\x99\xa0O\x02\xc3Q\x19+\xbfGC\xe3\xd6|\xe0\x94\xf8\xa3\xbf\x17N\xb7!\x16}\xc0\x13\xc4\xffG\x1fp\xf7~\xf4\xc1\xef2\xdbh\x91\xd0i!\xcfZ\x9e\xf6\xed2h\x90\x0f+\xa2\xf1\x19\xd0\xb9\x8dCg>\x15\r\x86A\x97\x00N\xf9\x1b\nQm\xdc\xc4"\x19\xd8G\xf2\xf1\xbd\xde\xa0\rp\x00yE\xa84"\x90}\x15m\x80\x85\xc8K\xc1\xce9\x16\x05\xde6T\x1a\xbd\xd1\xff,\xa6\xff_r\x08L;-w\xd4\x15o\xd2 \xdf\xf4\x85\x927Yw\x8c\x0bC]\x80\x16\x8fBe\x0bc\x81\xaa\xf9\x9f\xe8\\e\xa1: \x8b\x0cy8\x84^c\'K\\\x0f\xf0\x18\xcd\x8b\x8d\xe8g^\x99\x0c\xb0\xf8w\x80\xe4\x10\xf4{\xf1\xfa\xad[\x00\xfa\x92\xc9YP\xa4\xdd#(%j\x98\x99P\x17\x94\x85\n`C\xf8\xb5\xc6`@\xf8\x05\x1d@\xe1\x13\xf2/\xf7\x02\xa8$3G\xa7\xfc\x12\xc9\x84X\x1cZ\xb1K\x89\xc5\x15\xfe\xcb\xe2m \'\xe8\rz\x9f;\x88\xf9\xd7\x17a5\x8d\x048\x16\t\x9c\xac9\xd8i\x13\xf0J\xbcd\xd59\x80\xbdq\x003\xb29\x10\x9e&n\x7f\x8f\xf7a0\x9a|\x0c_h\x07\xd3\t\x1f\xdf\xd7\x8f\xf0SF\x83;\t*\xdf6\x0fZ\x0b\t\x7fpf\rY\xe1\x8a\xc3zO#\x1a\xd8\xeaI\x01\x1e\x9e\xf2zO9\x89\x8e\x13\xf1\xbb\xd5&\xe5^\xc6\x81`W}\xecv6\xf6\x8b\xe6eg/\x15\xa1>\xd4\x7f|\xf5\xf7r\xb4\x90U\xef\xdeK~IW\xac\xac\xa9S\xdf\xbb\xfc\xf2\xee\xd7d|G=N\xfc\x9d\xf0\x83\x9f\x1eH%\xfc\x80\x8a}ih\x8fA\xff\xe7\xfb2*\x08_\xa1\x8a.\x83\xc6=\xbc\x92^LG\xd4\xa5\x07\xe4\xd7r8\x1d\xd6\xb6\xa8K\x1dH\x8d\x1a\xfby\xd1qh0\xa87\x1d\xcf\x8d\xfa\xf7\xa3\xe3Y\xddg U\xb7\xca=\x07K\xce\xe3\x85*y\x0eg\xbeSw\xf4P\xa7\xe3\xa2]OU7b\x00\xb7\xec\xab\xe6Bd\xa9I\x7f\xadN\xe4\x0e\xdcG\x1e\xcc\xf8\xef<\x88Y\xe9K\x9e\t\xff\xc6d\xba\x8c\xf9\x7f\xa3"\xf9c0\xfc\xd5\xbf5"9:\x9e\xf1\xf6\x17\x0e`\xf6\xe7$\x93e/\x15\x95\xff\x024+\x06\xa4'  # noqa


def charTexCoords(char):
    """Returns the texture coordinates corresponding to a character
    :param str char: One Latin-1 character
    :returns: Texture coords uMin, vMin, uMax, vMax
    :rtype: tuple
    """
    index = ord(char.encode('latin1'))
    if index > ord('~'):
        index = max(96, index - 64)
    else:
        index = max(index - 32, 0)

    row, col = index // 16, index % 16
    return (col * cExtent,       row * rExtent,
            (col + 1) * cExtent, (row + 1) * rExtent)


def loadTexture():
    data = zlib.decompress(dataZip)
    return Texture2D(GL_RED, dataWidth, dataHeight,
                     type_=GL_UNSIGNED_BYTE,
                     minFilter=GL_NEAREST, magFilter=GL_NEAREST,
                     wrapS=GL_CLAMP_TO_EDGE, wrapT=GL_CLAMP_TO_EDGE,
                     data=data, unpackAlign=1)
