# -*- coding: binary -*-

# Module with methods for commonly used splunk URLs
module Msf::Exploit::Remote::HTTP::Splunk::URIs
  # Returns the Splunk Login URL
  #
  # @return [String] Splunk Login URL
  def splunk_url_login
    normalize_uri(target_uri.path, 'en-US', 'account', 'login')
  end

  # Returns the Splunk URL for the user's page
  #
  # @param username [String] username of the account
  # @return [String] Splunk user URL
  def splunk_user_page(username = nil)
    username = datastore['USERNAME'] if username.nil?
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'services', 'authentication', 'users', username)
  end

  # Returns the URL for splunk home page
  #
  # @return [String] Splunk home page URL
  def splunk_home
    normalize_uri(target_uri.path, 'en-US', 'app', 'launcher', 'home')
  end

  # Returns the URL for splunk upload page
  #
  # @return [String] Splunk upload page URL
  def splunk_upload_url
    normalize_uri(target_uri.path, 'en-US', 'manager', 'appinstall', '_upload')
  end

  # Returns the URL for the Splunk local apps management page
  #
  # @return [String] Splunk local apps management page URL
  def splunk_apps_url
    normalize_uri(target_uri.path, 'en-US', 'manager', 'search', 'apps', 'local')
  end

  # Returns the URL for splunk search api
  #
  # @param namespace [String] Splunk app context for execution
  # @return [String] Splunk search api URL
  def splunk_search_api_url(namespace = 'search')
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'servicesNS', 'admin', namespace, 'search', 'jobs')
  end

  # Returns the Splunk API URL for creating or managing dashboards in the specified namespace
  #
  # @param namespace [String] Splunk app or user context for execution
  # @return [String] Full URL for the dashboards API endpoint
  def splunk_dashboard_create_api_url(namespace)
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'servicesNS', 'admin', namespace, 'data', 'ui', 'views')
  end

  # Returns the Splunk API URL used for exporting a dashboard to PDF
  #
  # @param namespace [String] Splunk app or user context for execution
  # @param name [String] The name of the dashboard to export
  # @return [String] Full URL for the PDF export API endpoint
  def splunk_dashboard_pdf_export_api_url(namespace, name)
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'services', 'pdfgen', 'render')
  end

  # Returns the Splunk API URL for deleting a dashboard in the specified namespace
  #
  # @param namespace [String] Splunk app or user context for execution
  # @param name [String] The name of the dashboard to delete
  # @return [String] Full URL for the dashboard deletion API endpoint
  def splunk_dashboard_delete_api_url(namespace, name)
    normalize_uri(target_uri.path, 'en-US', 'splunkd', '__raw', 'servicesNS', 'admin', namespace, 'data', 'ui', 'views', name)
  end
end
