ITK Release 4.9
===============

New Features

------------------------------------------------------------------------

-   Wrapping improvements

`Python 3 supported`\
`Visual Studio 2015 supported`\
`C++14 standard supported`\
`GCC 6 supported`\
`Wrapping builds much faster due to CastXML binaries`\
`LandmarkBasedTransformInitializer now wrapped`\
`NumPy bridge with VisualStudio`\
`Wrapping for the MinimalPathExtraction module`\
`Wrapping is now installed into Python’s site-packages directory in the “itk” package`\
`Wrapping package size is decreased`\
`Better package portability on Mac OSX`

-   New Remote Modules

`Cuberille`\
`  Insight Journal Article: `[`https://hdl.handle.net/10380/3186`](https://hdl.handle.net/10380/3186)\
`AnisotropicDiffusionLBR`\
`  Insight Journal Article: `[`https://hdl.handle.net/10380/3505`](https://hdl.handle.net/10380/3505)\
`  Web browser reproducibility: `[`https://www.kitware.com/blog/home/post/942`](https://www.kitware.com/blog/home/post/942)

-   Core Improvements

`External Modules can now be developed outside of the ITK source tree and on GitHub`\
`Details: `[`https://www.kitware.com/blog/home/post/997`](https://www.kitware.com/blog/home/post/997)\
`New utilities in itk::Math: `\
`  AlmostEquals`\
`  NotAlmostEquals`\
`  ExactlyEquals`\
`  NotExactlyEquals`\
`New itk::NumericTraits`\
`  IsInteger`\
`  IsSigned`\
`Improved C++11 support`\
`New ITK_DELETE_FUNCTION macro for “=delete”`\
`New ITK_NOEXCEPT macro for the “noexcept” keyword`\
`Improved capabilities of itk::ResourceProbe and itk::ResourceProbesCollectorBase`\
`Improve numerical stability in VNL eigen system estimation`\
`itksys_ios:: and itksys_stl:: have been remove (use std::)`\
`ImageIO and TransformIO classes only get registered once in the object factory`\
`  The use of dynamic_cast with itk::TransformTemplate pointers should be avoided. It can fail on Mac OSX and older Linux systems.`

-   Filtering Improvements

`Generate a FlatStructuringElement from an image`\
`WarpImageFilter support VectorImage’s`\
`ConvertLabelMap supports different LabelMap types`\
`ImageToPathFilter moved from the ITKReview to the ITKPath module`\
`itk::MovingHistogramImageFilter moved to the ITKImageFilterBase module`

-   Registration Improvements

`Point-set registration with time-varying B-splines`

-   Build Improvements

`Module dependencies can now be specified as public / private / compile / test`\
`BUILD_EXAMPLES CMake option is now OFF by default`\
`Option to export all library symbols on Windows:`\
`Details: `[`https://www.kitware.com/blog/home/post/939`](https://www.kitware.com/blog/home/post/939)\
`Expat third party library is now name mangled`\
`Many more modules can be built as shared libraries`\
`KWStyle is automatically built and configured when tests are built`

-   Performance Improvements

`New MetaProgrammingLibrary namespace (itk::mpl) holds members for metaprogramming for compile-time determination of optimal code paths`\
`  itk::mpl::{TrueType,FalseType}`\
`  itk::mpl::{If,Not,And,Or,Xor}`\
`  itk::mpl::EnableIf`\
`  itk::mpl::IsBaseOf`\
`  itk::mpl::IsConvertible`\
`  itk::mpl::IsNumber`\
`  itk::mpl::IsSame`\
`  itk::mpl::PromoteType`\
`Image::GetPixel performance improvements`\
`Many itk::VariableLengthVector performance improvements`\
`AdaptiveHistogramEqualization uses a moving histogram`\
`WarpImageFilter performance improvements`

-   Documentation Improvements

`Updates to the Software Guide, Doxygen, Wiki and Sphinx Examples`\
`ITK Software Guide improvements`\
`  How to use Python wrapping`\
`  How to create an ITK module`\
`  Improvements to segmentation examples`\
`  Expanded Canny edge detection example`\
`  Expanded tree container example`\
`ITK Sphinx Examples improvements`\
`  Python wrapping in the ITK superbuild`\
`  Bootstrap-based HTML rendering`\
`  Python versions of examples`\
`  New examples`

-   Third Party Library Updates

`FFTW updated to latest upstream`\
`Build with recent OpenCV 2 and 3`\
`Build with the latest VTK`\
`PNG update to the latest upstream`\
`KWSys updated to the latest upstream`\
`MINC updated to the latest upstream`\
`SWIG updated to the latest upstream`\
`Third party PNG and MINC are now Git subtrees`

-   Style improvements -- ITK gets more stylish with every release!

`Private copy constructors and operator= use ITK_DELETE_FUNCTION`

-   Improved code coverage -- we are at 84.9%!

<!-- -->

-   -   Lots\* of important bug fixes

`Histogram-related outputs may change due to a fix to Histogram interval computation (Change-Id: I2063912edee79422d88125ffd5f7513c31a9e98c)`

Changes from v4.9rc03..v4.9.0

------------------------------------------------------------------------

Bill Hoffman (3):

`     COMP: fix 64 bit build warnings with windows auto-export on.`\
`     COMP: work around for VS 2015 optimizer bug causing test failures.`\
`     COMP: work around for VS 2015 optimizer bug causing test failures.`

Bradley Lowekamp (1):

`     BUG: Fix precision with accumulation and scaling in AdaptiveHistogram`

Davis Vigneault (1):

`     COMP: Include itkMacro.h in itkTestingMacros.h`

Dzenan Zukic (1):

`     COMP: fix itkStaticAssert warnings with clang++`

Hans Johnson (6):

`     COMP: BSD command lines do not have --version`\
`     COMP: Respect CMAKE_CXX_STANDARD during config`\
`     COMP: Clang Override warnings removed`\
`     BUG: Download URL was wrong for macosx`\
`     COMP: The ComputeUpdate function is needed`\
`     COMP: Incomplete solution for operators corrected`

Hyun Jae Kang (12):

`     COMP: Fixed the compiler error of ITKCommon2TestDriver on OSX 10.6`\
`     BUG: Fixed the runtime crash of vnl_test_complex on OSX 10.6`\
`     BUG: Fixed the runtime crash of itkTimeProbeTest2`\
`     BUG: Fixed the runtime crash of VideoSourceTest on OSX 10.6`\
`     BUG: Fixed the runtime crash of ITKReviewTestDriver on OSX 10.6`\
`     BUG: Fixed the runtime crash of ITKFastMarchingTestDriver's tests on OSX 10.6`\
`     COMP: Fixed the data conversion warning messages of itkResourceProbe`\
`     BUG: Fixed the runtime crash of ITKStatisticsTestDriver tests on OSX 10.6`\
`     BUG: Fixed the runtime crash of itkBinaryShapeOpeningImageFilterTest1`\
`     BUG: Fixed the runtime crash of test_pow_log on OSX 10.6`\
`     BUG: Fixed the runtime crash of vnl_test_numeric_traits`\
`     BUG: Exclude a test code of ITKLabelMapTestDriver on OSX 10.6`

Isaiah Norton (1):

`     COMP: fix build with -std=c++11 when ITK/VXL initially configured without`

Jon Haitz Legarreta (1):

`     BUG: Fix OpenCVBridge bug for two-byte images.`

Lucas Gandel (2):

`     BUG: Change CMAKE_SOURCE_DIR to CMAKE_CURRENT_SOURCE_DIR`\
`     BUG: Fix multiple external modules wrapping`

Martin Michlmayr (1):

`     COMP: fixed error `“`Dunno`` ``about`` ``this`` ``gcc`”` for gcc 6`

Matthew McCormick (22):

`     BUG: Do not perform dynamic_cast in CompositeIOTransformIOHelper.`\
`     COMP: Do not set property on itkhdf5 with ITK_USE_SYSTEM_HDF5.`\
`     DOC: Update the location of the GNUPlot Software Guide scripts.`\
`     DOC: Update the Software Guide repo location in Examples/README.txt.`\
`     COMP: Add export specification for itk::ResourceProbe.`\
`     COMP: Require NO_MODULE with DCMTK find_package.`\
`     COMP: Update CastXML revision for C++14 VS 2015.`\
`     BUG: Fix PythonTransformCoverage test for Python 3.4.`\
`     BUG: Fix PythonExtras test with Python 3.`\
`     BUG: Fix PythonTypemaps tests with Python 3.`\
`     ENH: Do not force shared libraries when wrapping.`\
`     DOC: Update WikiExamples to 2016-10-20`\
`     BUG: BUILD_TESTING should be not advanced.`\
`     COMP: Use enum in itkStaticConstMacro for old GCC.`\
`     BUG: Correct FlatStructuringElement wrapping location.`\
`     BUG: Correct itkStaticConstMacro GCC version comparison operator.`\
`     BUG: Improve GCC detection in itkStaticAssert.h preprocessor macro.`\
`     BUG: Fix OpenCV version check.`\
`     DOC: Update the SphinxExamples Remote Module.`\
`     COMP: Wrap FlatStructuringElement before other classes.`\
`     COMP: Workaround inconsistent OpenCV pre-processor variables.`\
`     COMP: Update CastXML to support wrapping with GCC 6.`

Michka Popoff (3):

`     ENH: Allow Python 3 wrapping for Glue and Review Modules with VTK 7`\
`     COMP: Re-enable review module for python 3 and older VTK's`\
`     ENH: Use importlib for python 3.4 instead of imp`

Nick Tustison (1):

`     ENH:  Accommodate epsilon error on left side.`

Sean McBride (1):

`     DOC: Update some woefully out-of-date GDCM comments, and typos`

Seun Odutola (1):

`     BUG: Improved itkAnalyzeImageIO to handle case insensitive extensions`

Sumedha Singla (3):

`     ENH: Fixed the numeric traits for datatypes`\
`     DOC: Added a comment to support the changes in numeric traits datatypes.`\
`     BUG: Invalid memory access of itk::NotAlmostEquals Bug#ITK-3403`

Changes from v4.9rc02..v4.9rc03

------------------------------------------------------------------------

Alexis Girault (1):

`     BUG: Implement SetAutoMinimumMaximum in itkScalarImageToHistogramGenerator`

Bill Lorensen (1):

`     BUG: nifti_read_subregion_image was leaking file pointers`

Brad King (7):

`     ENH: Teach ITK module macros to support independent header-only modules`\
`     ENH: Add script to import KWIML library source code`\
``      ENH: Add `ITKKWIML` module to provide external KWIML library ``\
`     ENH: Port TIFF integer types from KWSys to KWIML`\
`     ENH: Port LSM integer types from KWSys to KWIML`\
`     ENH: Port itkIntTypes.h from KWSys to KWIML`\
`     ENH: Drop KWSys FundamentalType component`

Bradley Lowekamp (1):

`     ENH: Add option to choose scheme for git download`

Davis Vigneault (1):

`     STYLE: Use cstdlib return macros in ITK examples`

Dženan Zukić (3):

`     BUG: do not pass 0,0,0 to Versor.Set()`\
`     STYLE: Removing the unused NeighborhoodRadius property`\
`     ENH: Write out transform in DeformableRegistration15`

Gert Wollny (1):

`     BUG: Remove double-conversion from public interface, use system.`

Hyun Jae Kang (8):

`     ENH: Create a test for the SpawnThread function ( ITK-3317)`\
`     STYLE: Remove an unnecessary file (-w) from source code`\
`     BUG: Fixed the failed case of itkStdStreamStateSaveTest on OS X 10.8`\
`     BUG: Fixed the failed test case of itkThreadPoolTest on OS X 10.8`\
`     BUG: Fixed a failed test of ITKDistanceMapTestDriver`\
`     BUG: Fixed the failed test VideoSourceTest`\
`     PERF: Improve the performance of a test of ITKRegistrationMethodsv4TestDriver`\
`     COMP: Fixed the compiler error of itkDisplacementFieldToBSplineImageFilterTest`

Jean-Christophe Fillion-Robin (25):

`     BUG: Build ITKIOTransformHDF5 as shared library. See #3393`\
`     BUG: Build ITKIOTransformMINC as shared library. See #3393`\
`     BUG: Build ITKIOTransformMatlab as shared library. See #3393`\
`     BUG: Build ITKIOTransformInsightLegacy as shared library. See #3393`\
`     STYLE: TransformIOFactory: Remove obsolete declaration. See #3393`\
`     COMP: TransformIOFactory: Add missing ctor/dtor from hxx file. See #3393`\
`     COMP: TransformFileWriter: Remove method `“`OpenStream()`”` without definition`\
`     COMP: TransformFileReaderTemplate: Remove undefined method `“`CreateTransform()`”\
`     ENH: Update ITKIOPhilipsREC to allow static initialization. See #3393`\
`     ENH: Update ITKIOTransformMINC to allow static initialization. See #3393`\
`     COMP: MINC: Fix VS2008 `“`unknown`` ``round`”` build error. See #3393`\
`     COMP: MINC: Fix VS2008 `“`unknown`` ``arpa/inet.h`”` build error. See #3393`\
`     COMP: Configure ENABLE_SHARED into `<ModuleName>`.cmake file. See #3393`\
`     COMP: Fix configuration of IOFactory header. See #3393`\
`     STYLE: UseITK: Removed redundant code setting ImageIO factory name. See #3393`\
`     STYLE: UseITK: Re-factor introducing _configure_IOFactoryRegisterManager`\
`     STYLE: UseITK: Set TransformIO factory and module name using convention.`\
`     BUG: Ensure Image IO factories are registered once. See #3393`\
`     BUG: Ensure Transform IO factories are registered once.`\
`     COMP: ITKIOXML: Fix VS11 `“`already`` ``defined`` ``std::string`”` link error. See #3393`\
`     BUG: TransformIO: Implement explicit template instantiation using `“`extern`”`.`\
`     COMP: TransformIO: Fix VS build errors removing extra EXPORT`\
`     COMP: TransformIO: Handle compiler not supporting `“`pragma`` ``diagnostic`”`.`\
`     COMP: TransformIO: TransformFile(Reader|Writer) still need to be exported.`\
`     COMP: TransformIO: Fix explicit instantiation approach`

Johan Andruejol (1):

`     ENH: Add ITK_RUNTIME_LIBRARY_DIRS for external projects`

KWIML Upstream (1):

`     KWIML 2015-12-09 (43f9f8d0)`

Lucas Gandel (1):

`     BUG: PhysicsBasedNonRigidRegistrationMethod test failure on Debian 32bit`

Matthew McCormick (16):

`     COMP: Fix PointDimension reference in AzimuthElevationToCartesian test.`\
`     STYLE: Improve scoping in AzimuthElevationToCartesian test.`\
`     STYLE: Explicitly mark the ProcessObject methods virtual in SignedMaurer.`\
`     BUG: Do not try to install targets that do not exist when building externally.`\
`     BUG: ITKIOMeta needs a public dependency on ITKMetaIO.`\
`     COMP: Update LesionSizingToolkit for external build and style test failures.`\
`     BUG: Add CMake OpenCV export code to ITKVideoBridgeOpenCV.`\
`     COMP: Improve compatibility with OpenCV 3.`\
`     DOC: Fix class references in StatisticsLabelMapFilter.`\
`     STYLE: Improved readability of itkStatisticsUniqueLabelMapFilterTest1.`\
`     DOC: Correct ReverseOrdering description in ShapeUniqueLabelMapFilter.`\
`     STYLE: Add own copy of GenerateExportHeader`\
`     COMP: Create _TEMPLATE_EXPORT macros.`\
`     COMP: TransformIOBaseTemplate must be explicitly instantiated.`\
`     BUG: Do not use dynamic_cast for DisplacementFieldType in HDF5 test.`\
`     COMP: Do not use string(MAKE_C_IDENTIFIER with CMake < 2.8.12`

Max Smolens (1):

`     BUG: VoronoiSegmentationRGBImageFilter: add pixel dimension check`

Mikhail Isakov (1):

`     DOC: correction in DiffusionTensor3D Reconstruction`

Ricardo Ortiz (1):

`     BUG: Set itkBinaryImageTo*LabelMapFilter foreground/background values`

Seun Odutola (1):

`     BUG: absolute value of tolerance taken to cater for negative spacing`

Shawn Waldon (1):

`     COMP: OSX set deployment target when building fftw`

Simon Alexander (4):

`     STYLE: Change to make git bash on windows happy with the function name`\
`     COMP: fixes for visual studio 2015update1 x86 in release mode`\
`     COMP: fixes for visual studio 2015update1 x86 in release mode`\
`     COMP: fixes for visual studio 2015update1 x86 in release mode`

Sreekanth Arikatla (2):

`     BUG: Resolved const correctness in itkMatrix.h`\
`     ENH: Fixes the symmetry of AzimuthElevationToCartesianTransform and adds tests`

Changes from v4.9rc01..v4.9rc02

------------------------------------------------------------------------

Bill Lorensen (1):

`     BUG: Valgrind detected an invalid read`

Davis Vigneault (1):

`     STYLE: Address some warnings when running cppcheck`

Hyun Jae Kang (2):

`     COMP: Fixed a warning message of data-conversion on VS14`\
`     COMP: Update KWStyle to remove format-string warning message`

Matthew McCormick (3):

`     DOC: Remove invalid wrapping example.`\
`     BUG: Wrap AdaptiveEqualizationHistogram.`\
`     COMP: Ignore Doxygen endcond warning in itkIsConvertible.h.`

Seun Odutola (1):

`     COMP: Corrected minc2.h path installation from libsrc2/minc2.h to minc2.h`

Ziv Yaniv (2):

`     BUG: Affine transformation was estimated without sufficient number of points.`\
`     BUG: fixed BSpline initializer crash when reference image not set.`

Changes from v4.8.0..v4.9rc01

------------------------------------------------------------------------

Abhishek Tiwari (1):

`     BUG: `“`tmpImageIndex`”` not initialized to 0.`

Adam Snyder (1):

`     PERF: Reworked MMI Threading using a per-thread buffer`

Alexander Leinoff (6):

`     ENH: Adds IsInteger and IsSigned to NumericTraits.`\
`     COMP: Doxygen itkMath.h 'OneValue()' could not be resolved.`\
`     ENH: Adds ExactlyEquals and NotExactlyEquals functions to itkMath.h`\
`     COMP: Removes floating-point equality checks`\
`     ENH: COMP: Adds support for complex values to Math::AlmostEquals`\
`     ENH: Updates fftw dependency`

Arnaud Gelas (5):

`     COMP: fix warning (unused local typedef)`\
`     COMP: simplify ITKVideoBridgeOpenCV dependency`\
`     DOC: add doxgen documentation for BinaryImageToLevelSetImageAdaptor`\
`     ENH: add tests to exercise itk::ThreadedIteratorRangePartitioner`\
`     COMP: fix compilation error with OpenCV2 and OpenCV3`

Betsy McPhail (1):

`     BUG: Improve buffer alignment in OctreeNode .`

Bill Hoffman (2):

`     ENH: Use new CMake Windows export symbol dll feature.`\
`     COMP: Put vnl_export.h in the list of sources so it gets installed.`

Bill Lorensen (4):

`     COMP: VTkGlue linker errors`\
`     BUG: Inappropriate use of AlmostEquals`\
`     ENH: Bump tag for wiki examples`\
`     ENH: Better layout strategy`

Brad King (3):

`     ENH: Remove use of include `<itksys/ios/*>` and itksys_ios::*`\
`     ENH: Remove use of include `<itksys/stl/*>` and itksys_stl::*`\
`     ENH: Update CMake Policy settings in Testing/TestExternal project`

Bradley Lowekamp (31):

`     BUG: Avoid null deference in PrintSelf with default construction`\
`     ENH: Enable base classes for templates of landmark initializer`\
`     STYLE: Use `“`Swap`”` for ITK member name`\
`     BUG: Demonstrate Eigen analysis failure`\
`     BUG: Fix computation of Eigen analysis`\
`     ENH: Update DiscreteHessianGaussian Test baseline`\
`     ENH: Correctly demonstrate float point Eigen failure`\
`     ENH: compile vnl_math_hypot, and use at least double`\
`     ENH: Adding initial update script from used libpng version.`\
`     ENH: removing non-subtree files for itkpng`\
`     ENH: Ported ITK changes for building to subtree merged code`\
`     ENH: Update libpng update script for v1.6.9`\
`     BUG: Use ParameterValueType for computation of landmark affine`\
`     ENH: Wrap LandmarkBasedTransformInitializer`\
`     BUG: Avoid potential exception in itk::Object::UnRegister`\
`     ENH: Update itkpng zlib, configuration, and rename`\
`     ENH: Update itkpng name mangling`\
`     BUG: Use const pointer in Set method for constant ReferenceImage ivar`\
`     BUG: Increase tolerance for PhysicsBasedNonRigidRegistrationMethod`\
`     BUG: Demonstrate side effect on registration due to BSplineScatter change`\
`     ENH: Move MovingHistogramImageFilter base classes to ImageFilterBase`\
`     BUG: Avoid potential exception in itk::Object::UnRegister`\
`     BUG: Avoid null deference in PrintSelf with default construction`\
`     BUG: Use const pointer in Set method for constant ReferenceImage ivar`\
`     ENH: Optimize AdaptiveHistogramEqualization with MovingHistogram base`\
`     COMP: address sign unsigned comparison warning`\
`     COMP: Address signed unsigned comparison warning`\
`     COMP: Address unused member variable and methods in anonymous ns`\
`     BUG: Fix segfault when with empty IsolatedWatershed Threshold range`\
`     BUG: Adjust intensity tolerance for PhysicsBasedNonRigid test`\
`     BUG: Reduce number of targets with MSVC`

Davis Vigneault (7):

`     DOC: Minor improvements to segmentation examples.`\
`     DOC: Expanded Canny Edge Detection Example`\
`     DOC: Expanded TreeContainer Example`\
`     COMP: Warnings in itkVTKImageExport when compiling with c++11`\
`     COMP: Warnings in FFTW Classes when compiling with c++11`\
`     COMP: Update Git Tag for Subdivision Module`\
`     COMP: Warnings in FFTW Classes when compiling with c++11`

Dženan Zukić (1):

`     STYLE: better formatting of the `“`usage`”` message`

Eugene Prilepin (1):

`     BUG: Fix a template name formation in python wrappings`

Floris Berendsen (1):

`     STYLE: Improve naming conventions in comments.`

Hans Johnson (29):

`     STYLE: Instrument for FixedParameters typedef`\
`     BUG: Demonstrate DisplacementTransformFailure`\
`     BUG: FixedParameters should be double precision`\
`     STYLE: Minor code style issues for MGHIO`\
`     COMP: Update to version for WikiExamples`\
`     ENH: Update Sphinx for ITK 4.8.0`\
`     ENH: Update MGHIO to be shared lib`\
`     ENH: Provide consistent floating point comparisons`\
`     BUG: Fix MGHIO to fix write failures`\
`     PERF: Remove floating point as sentinal value`\
`     COMP: Const correctness needs to be maintained`\
`     BUG: Preserve backwards compatibility`\
`     DOC: Provide consistent naming in comments`\
`     ENH: Conversion between transform type tolerance`\
`     STYLE: Prefer initialization to assignment`\
`     ENH: Missing ITK_OVERRIDE`\
`     COMP: Need to propagate ITKGDCM`\
`     COMP: Need to propagate ITKGDCM`\
`     COMP: Add missing ITK_OVERRIDE`\
`     STYLE: Minor code style issues for MGHIO`\
`     COMP: Update to version for WikiExamples`\
`     ENH: Update Sphinx for ITK 4.8.0`\
`     ENH: Update MGHIO to be shared lib`\
`     BUG: Fix MGHIO to fix write failures`\
`     ENH: C++11 allows for rigorous =delete`\
`     COMP: Remove unnecessary failing assert test`\
`     ENH: Ignore internal files for the Clion editor`\
`     COMP: Fix VNL compilation for wider C++11 support`\
`     BUG: In configuration test need to mirror code`

Hyun Jae Kang (27):

`     BUG: Remove std::cout calls from class`\
`     BUG: Avoid an unexpected output of static_cast`\
`     BUG: Update python example codes for ImageRegistration`\
`     BUG: Retrieve the missed wrap file`\
`     BUG: itkVTKImageIO class does not handle blank lines in VTK file header.`\
`     BUG: Fix HDF5 CMake configuration with VS2015`\
`     BUG: Fix a compilation issue on ITK4 with FFTW and shared libraries`\
`     BUG: Fixed older XCode linking error`\
`     ENH: Use CastXML binaries when building with x86_64 Mac OS X`\
`     BUG: Remove std::cout calls from class`\
`     BUG: itkVTKImageIO class does not handle blank lines in VTK file header.`\
`     BUG: Fixed older XCode linking error`\
`     ENH: Add automatic KWStyle build and configuration setup`\
`     COMP: KWStyle shadow, format-nonliteral and autological-compare warning.`\
`     COMP: Fixed the warning messages from itkGPU Module`\
`     COMP: Fixed a warning message of unused-private-field`\
`     COMP: Apply latest version of KWStyle`\
`     COMP: Update KWStyle to fix its additional warning messages`\
`     COMP: Update KWStyle to fix its additional warning messages`\
`     COMP: Fix data-conversion warning messages on Windows`\
`     ENH: Update itkResourceProbe to calculate statistical data`\
`     COMP: Fix data-conversion warning messages on VS14`\
`     COMP: Fixed 'std::sqrt' : ambiguous call to overloaded function`\
`     ENH: Update the Report() function of itkResourceProbesCollectorBase`\
`     COMP: Fix data-conversion warning message on itkResourceProbe`\
`     COMP: Fix additional warning messages of KWStyle`\
`     COMP: Fix data-conversion warning messages`

Jon Haitz Legarreta (6):

`     ENH: Add test for itkStatisticsUniqueLabelMapFilter`\
`     BUG: Fix compilation issues for StatisticsUniqueLabelMapFilterTest`\
`     BUG: Fix comparison issues for itkStatisticsUniqueLabelMapFilter`\
`     BUG: Test for StatisticsUniqueLabelMapFilter stability`\
`     ENH: Add test for itkParametricStpaceToImageSpaceFilter`\
`     ENH: Improve code coverage for itkParametricSpaceToImageSpaceMeshFilter`

Julien Michel (1):

`     ENH: Support of VectorImage as template parameters for WarpImageFilter`

Junjie Bai (2):

`     BUG: ConvertLabelMap with different LabelMapTypes`\
`     BUG: LabelObject CopyAttribute support different LabelObject type`

KWSys Robot (4):

`     KWSys 2015-07-10 (c9336bcf)`\
`     KWSys 2015-07-30 (f63febb7)`\
`     KWSys 2015-08-24 (cdaf522c)`\
`     KWSys 2015-08-28 (dc3fdd7f)`

LIBPNG Upstream (2):

`     PNG 2009-04-06 (e68f5a36)`\
`     PNG 2014-02-05 (3e753eb8)`

Laurentiu Nicola (2):

`     PERF: Avoid temporary smartptr in ProcessObject::GetInput`\
`     PERF: Optimize WarpImageFilter by avoiding refcount bouncing`

Luc Hermitte (8):

`     PERF: itk::Image::GetPixel() performance improvment.`\
`     PERF: Performance enhancements on VariableLengthVectors 1/...`\
`     ENH: Dependencies on itkVariableLengthVector.h reduced`\
`     BUG: Error in VariableLengthVector Unit Tests`\
`     PERF: Performance enhancements on VLV 2/...`\
`     PERF: Performances enhancements on VLV 3/...`\
`     COMP: Fix signed/unsigned warnings`\
`     BUG: std::copy/fill on empty VLV`

Lucas Gandel (4):

`     ENH: Move ImageToPathFilter from ITKReview to ITKPath module.`\
`     BUG: Fixing ImageToPathFilter wrapping call from Review Module`\
`     STYLE: Fix KWStyle dashboard errors`\
`     BUG: Fix external module BUILD_SHARED_LIBS status`

Mathieu Malaterre (1):

`     BUG: Name mangle the included expat third party library.`

Matthew McCormick (94):

`     ENH: Change itkSystemInformationTest to itkCMakeConfigurationTest.`\
`     ENH: Add AnisotropicDiffusionLBR Remote Module.`\
`     ENH: Bump ITK version to 4.9.0.`\
`     BUG: Remove std::cout calls from classes.`\
`     COMP: Remove unused argument in ConditionVariableNoThreads.`\
`     BUG: Implement UpdateLargestPossibleRegion for ImageToVTKImageFilter.`\
`     COMP: Add link interface specification for wrapping target_link_libraries.`\
`     STYLE: Fix indentation in itkMINCTransformIOFactory.cxx.`\
`     COMP: Fix MINCTransformIO factory registration.`\
`     COMP: Add -D_LARGEFILE64_SOURCE for HDF5 with Emscripten-1.`\
`     COMP: Remove unknown doxygen command in AnisotropicDiffusionLBR.`\
`     BUG: Initialize mutex for 32 bit AtomicInt.`\
`     ENH: Use CastXML binaries when building with x86_64 Linux.`\
`     STYLE: Rename gccxml -> castxml in {idx,igenerator}.py.`\
`     COMP: Disable the gold linker for static builds on Ubuntu 14.04.`\
`     ENH: Use Windows binaries for CastXML.`\
`     ENH: Add better scoping in igenerator.py.`\
`     BUG: Fix CMAKE_BUILD_TYPE initialization with Ninja + MSVC.`\
`     BUG: LevelSetsv4 used signed char instead of char.`\
`     ENH: Add better scoping to idx.py.`\
`     COMP: Define newSize and oldSize in VariableLengthVector.`\
`     STYLE: Use prefix increment operator in ImageBase.`\
`     DOC: Correct spelling of Continuous.`\
`     ENH: Add more progress information to IterativeClosestPoint2.`\
`     BUG: Build BridgeNumPy with Visual Studio.`\
`     ENH: Add ITKModuleExternal.cmake`\
`     COMP: Wrap Image< bool, D > for FlatStructuringElement.`\
`     BUG: Use CastXML binary built in Release.`\
`     BUG: ContinuousIndex should not be templated over TCoordRep.`\
`     COMP: Set CMP0054 to new.`\
`     COMP: Address line length too long for Software Guide.`\
`     COMP: Fix CannyEdgeDetectionImageFilter.cxx types.`\
`     BUG: Support Python 3 wrapping module initialization.`\
`     BUG: Update itkTemplate.py for Python 3.`\
`     BUG: Update itkExtras.py for Python 3.`\
`     BUG: Prevent Python callback addition recursion.`\
`     BUG: Fix test scripts for Python 3.`\
`     BUG: Replace __GCCXML__ with CABLE_CONFIGURATION.`\
`     ENH: Allow projects to build against an external module.`\
`     ENH: Replace CABLE_CONFIGURATION with ITK_WRAPPING_PARSER.`\
`     ENH: Rename _cable_ to _wrappers_.`\
`     BUG: Replace __GCCXML__ with CABLE_CONFIGURATION.`\
`     BUG: Define ITK_WRAPPING_PARSER when wrapping.`\
`     COMP: Do not use C++11 alignas in itkAlignedTypedef.`\
`     ENH: Bump CMakeLists.txt version to 4.8.1.`\
`     BUG: Pass the CMAKE_CXX_FLAGS to castxml.`\
`     ENH: Bump CastXML version to 2015-30-29.`\
`     ENH: Bump LLVM / Clang to 3.7.0.`\
`     COMP: Avoid itklibminc linking with ITK_USE_SYSTEM_HDF5.`\
`     COMP: Add missing ITKIOImageBase dependency for ITKTransformMINC.`\
`     COMP: Use itkSimpleNewMacro in ThreadedIteratorRangePartitionerTest.`\
`     ENH: Add wrapping support for building modules externally.`\
`     BUG: Fix KWStyle test paths when building a module externally.`\
`     ENH: Add Cuberille Remote module.`\
`     COMP: Remove carriage returns from Cuberille remote.`\
`     COMP: Remove unused argument in ConditionVariableNoThreads.`\
`     DOC: Correct spelling of Continuous.`\
`     ENH: Bump the MinimalPathExtraction Remote to 2015-10-20.`\
`     COMP: Fix KernelTransform SetFixedParameters argument type.`\
`     STYLE: Use prefix increment operator in ImageBase.`\
`     COMP: Use ITK's pygccxml by correctly setting up the sys.path`\
`     Revert `“`COMP:`` ``Put`` ``vnl_export.h`` ``in`` ``the`` ``list`` ``of`` ``sources`` ``so`` ``it`` ``gets`` ``installed.`”\
`     BUG: Revert `“`BUG:`` ``ConvertLabelMap`` ``with`` ``different`` ``LabelMapTypes`”\
`     ENH: Marking wrapping CMake configuration variables as advanced.`\
`     STYLE: Rename CASTXML to CASTXML_EXECUTABLE.`\
`     COMP: Non-virtual copy attribute members in LabelMap cannot have override.`\
`     COMP: Add wrapping for AdaptiveHistogramEqualizationImageFilter.`\
`     COMP: Add itkMacro.h to itkPromoteType.h for ITK_EXCEPT.`\
`     ENH: Remove CMake version check in ITKModuleHeaderTest.cmake`\
`     BUG: Improve KWStyle ExternalProject utilization.`\
`     ENH: Remove old KWStyle build script.`\
`     COMP: Address VariableLengthVector Doxygen rhs @param not found.`\
`     ENH: Rename WRAPPING_LIBRARY_GROUPS to WRAPPING_SUBMODULE_ORDER.`\
`     ENH: Install Python bindings into site-packages.`\
`     ENH: Improve readability of Python site-packages path detection.`\
`     COMP: DiscreteGaussianDerivativeImageFilter unsigned expression warning.`\
`     BUG: ITKCommon publically depends on ITKDoubleConversion.`\
`     COMP: Improve scoping in CovariantVectorGeometryTest.`\
`     ENH: Improves names and export of module dependencies.`\
`     STYLE: Improve namespace bracket style in itkIsConvertible.`\
`     COMP: Set CMP0054 to new.`\
`     BUG: Remove unused wrapping files.`\
`     BUG: Do install install wrapping development files.`\
`     ENH: Add WRAP_ITK_INSTALL_COMPONENT_IDENTIFIER.`\
`     BUG: Remove duplicate inclusion of wrapping submodules.`\
`     COMP: Do not use C++ style comments for Doxygen cond.`\
`     BUG: Fix detection of the gold linker.`\
`     BUG: Update Python package installation locations.`\
`     ENH: Bump CMakeLists.txt version to 4.8.2.`\
`     ENH: Change BUILD_EXAMPLES default to OFF.`\
`     BUG: Use 'from itk import ITKCommon' in module2module test.`\
`     COMP: Link to VTK Python when built with Kits support.`\
`     BUG: Install itk_minc2.h header.`\
`     COMP: ITKIOMINC has a public dependency on ITKIOImageBase.`

Michka Popoff (9):

`     ENH: Update to swig 3.0.7`\
`     ENH: Do not link against specific Python library on OS X`\
`     COMP: Fix wrapping warnings when building with ITK_WRAP_IMAGE_DIMS=2`\
`     COMP: Add missing wrapping for TransformBase`\
`     COMP: Use ITK's pygccxml by correctly setting up the sys.path`\
`     COMP: Disable incompatible modules when using Python 3 wrapping`\
`     COMP: Move MovingHistogramImageFilterBase wrapping to ImageFilterBase module`\
`     COMP: Disable incompatible modules when using Python 3 wrapping`\
`     ENH: Allow operations on Indexes and Offsets in Python`

Mikhail Isakov (1):

`     BUG: DiffusionTensor3DReconstruction segfault if no baseline image`

Nick Tustison (5):

`     BUG:  Set a default b-spline epsilon.`\
`     ENH: Adding testing for closed loop.`\
`     BUG:  Updating B-spline classes with the same epsilon strategy.`\
`     PERF:  Switch vnl_vectors for fixed arrays.`\
`     ENH:  Point-set registration with time-varying B-spline.`

Olivier Commowick (3):

`     BUG: Correct discrepancy in tridiagonal reduction wrt VNL eigen system`\
`     BUG: Correct under/overflows in vnl_math_hypot (taken from pythag from V3P)`\
`     BUG: Switch eigenvalues computation to double`

Pablo Hernandez-Cerdan (2):

`     ENH: Help class for itkFlatStructuringElement with constructor from images.`\
`     COMP: Fix test errors and warnings in FlatStructuringElement.`

Seun Odutola (1):

`     COMP: Fixed name clash with Apple header (check Macro), renamed check to Check`

Shawn Waldon (1):

`     COMP: Set target OS X version in environment for tools using compiler`

Simon Alexander (1):

`     BUG: incorrect closest point computation`

Tobias Wood (2):

`     BUG: LBFGSB was printing messages even with debug switched off.`\
`     BUG: Removed an unguarded print statement.`

Vladimir S. FONOV (9):

`     BUG: Missing ITKIOMINC_EXPORT on __Private()`\
`     COMP: Changing the order of HDF5 library components`\
`     COMP: Splitting up IOMINC module into two parts: MINC and Transform`\
`     STYLE: updated comments to properly reference LIBMINC`\
`     ENH: Add script to merge upstream MINC as a subtree`\
`     MINC 2015-07-23 (c033d431)`\
`     COMP: Update MINC CMake code`\
`     MINC 2015-08-18 (6d7e3ba8)`\
`     MINC 2015-09-13 (95cd5374)`

Xiaoxiao Liu (1):

`     DOC: update email address for xiaoxiao.`

Zach Williamson (10):

`     BUG: Use correct libraries for ImageFusion tests`\
`     ENH: Consolidate Library Dependencies`\
`     COMP: Add a missing link to Review module`\
`     COMP: Use correct linking macro in DCMTK`\
`     BUG: Use correct libraries for TestKernel tests`\
`     COMP: Fix inconsistant naming of GPUPDEDeformableRegistration`\
`     ENH: Use new linking system macros`\
`     PERF: Avoid searching private dependencies for include directories`\
`     COMP: Recover missing dependencies`\
`     ENH: use new linking macros in Filtering module`

ITK Sphinx Examples Changelog

------------------------------------------------------------------------

Brad King (1):

`     ENH: Remove use of itksys_ios::*`

Dženan Zukić (1):

`     ENH: Avoid warning window when the directory does not contain any DICOM series`

Hans Johnson (1):

`     BUG: FixedParameters different from Parameters`

Matt McCormick (38):

`     ENH: Bump ITK ExternalProject to v4.8.0.`\
`     COMP: Do not try to add html files twice to the tarballs.`\
`     BUG: Turn off ITK modules when superbuild options are disabled.`\
`     DOC: Consistently refer to source directory in length warning.`\
`     BUG: Use os.path.sep for CreateNewExample.py on both Unix and Windows.`\
`     ENH: Use a StringIO for the headers content in CreateNewExample.`\
`     ENH: Make CreateNewExample compatible with Python 3.`\
`     ENH: Enable BridgeNumPy in the Superbuild when NumPy available.`\
`     ENH: Silence gitstats execution.`\
`     ENH: Add sphinx-bootstrap-theme submodule.`\
`     ENH: Update ITK ExternalProject to 4.9rc02.`\
`     COMP: Support OpenCV 3.0.0.`\
`     BUG: Pass the Sphinx output components in the superbuild.`\
`     BUG: Work around epub output filename irregularity.`\
`     ENH: Use side-by-side images in Binary Mathematical Morphology.`\
`     ENH: Use all caps in Binary Mathematical Morphology examples.`\
`     ENH: Move the Download button location.`\
`     BUG: Rename CreateAnApplyCustomColormap -> CreateACustomColorMap.`\
`     ENH: Use note directive in CreateACustomColorMap.`\
`     ENH: Move ITkExampleMacros.cmake into the CMake/ directory.`\
`     STYLE: Use more standard spacing in ITKExamplesMacros.cmake.`\
`     DOC: Improve TryCatchException result rendering and synopsis.`\
`     DOC: Update the Download page image for the bootstrap layout.`\
`     ENH: Use presence of Code.py to create Python baseline comparison tests.`\
`     DOC: Fix ComputeTimeBetweenPoints output rendering.`\
`     ENH: Add Python version of ComputeTimeBetweenPoints.`\
`     ENH: Demonstrate Report() in ComputeTimeBetweenPoints.`\
`     ENH: Add Python superbuild.`\
`     COMP: Fix type of Sphinx output variables.`\
`     BUG: Ensure that the JavaScript files get copied to HTML output.`\
`     COMP: Fix ConceptCheckingIsFloatingPoint index entry.`\
`     BUG: Avoid system installation without superbuild Python.`\
`     COMP: Find ITKExamplesMacros.cmake when build as a Remote Module.`\
`     COMP: Support OpenCV 3 in ConvertAnITKGrayScaleImageToCVMat.`\
`     COMP: Support double typed FixedParameters in ITK 4.9.0`\
`     BUG: Do not run Python comparison tests without ITK_WRAP_PYTHON.`\
`     BUG: Correct CreateACustomColorMapTestPython test name.`\
`     ENH: Bump ITK ExternalProject to 4.9.0.`

Michka Popoff (4):

`     ENH: Add ImageRegistration1 example`\
`     COMP: Fix images in 2D Translation Registration`\
`     ENH: Add AddOffsetToIndex Python example`\
`     ENH: Add missing licence headers and hide headers in doc`

ITK Software Guide Changelog

------------------------------------------------------------------------

Matt McCormick (9):

`     COMP: Address missing bracket and backslash escapes.`\
`     BUG: Fix backslash specification in Windows PATH.`\
`     DOC: Recommend the Release build configuration when wrapping.`\
`     DOC: Document .GetTypes and Python type conversion.`\
`     DOC: Add chapter on how to create a module.`\
`     COMP: Do not set PYTHONCXXPARSER with find_program.`\
`     ENH: Update ITK ExternalProject to v4.9rc01.`\
`     DOC: Corrections to formatting of wrapping content.`\
`     ENH: Bump ITK ExternalProject version to v4.9.0.`
