# This is a CamiTK python action
#
# Simple test of the interaction between python and the CamiTK application
# using 'self'. 
# This is a simple test where a counter is incremented in the process() method
# using an attribute saved in the action's self dict.
# 
# It demonstrates how state can be preserved between action 'apply' calls using
# internal variables. Note that the parameter is set to 'read only' for this 
# action as a way to prove the internal self.counter increments properly.

import camitk

def init(self:camitk.Action):
    self.counter = 42

def process(self:camitk.Action):    
    self.counter += 1
    self.setParameterValue("Counter", self.counter)
    # to update the GUI
    self.updateWidget()
