import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
const _excluded = ["line", "column"],
  _excluded2 = ["line", "column"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
export const THEME_LIGHT = "light";
export const THEME_DARK = "dark";
export const THEME_AUTO = "auto";
export const defaultLineNumberFormatter = (line, lineCount) => {
  if (lineCount === 1) {
    return "$";
  } else {
    return line;
  }
};
export const defaultAutocompleteTriggerStrings = [".", ":", "[]", "()", "{}", "[", "(", "{", "$"];
export const defaultOptions = {
  autocomplete: true,
  autocompleteCloseOnBlur: true,
  autocompleteOpen: false,
  autocompleteTriggerStrings: defaultAutocompleteTriggerStrings,
  autofocus: true,
  autofocusProps: ["cursorWide", "position", "readOnly", "selection", "value"],
  bracketMatching: true,
  clearHistoryProps: ["cypherLanguage"],
  closeBrackets: true,
  cursorWide: true,
  cypherLanguage: true,
  history: true,
  indentUnit: "  ",
  lineNumberFormatter: defaultLineNumberFormatter,
  lineNumbers: true,
  lineWrapping: false,
  lint: false,
  parseOnSetValue: true,
  placeholder: undefined,
  position: undefined,
  readOnly: false,
  readOnlyCursor: false,
  schema: undefined,
  search: true,
  searchMatches: 0,
  searchOpen: false,
  searchText: "",
  searchTop: false,
  selection: undefined,
  tabKey: true,
  theme: THEME_LIGHT,
  tooltipAbsolute: true,
  value: "",
  preExtensions: [],
  postExtensions: []
};
export const reactiveOptionKeys = ["autocomplete", "autocompleteCloseOnBlur", "autocompleteOpen", "autocompleteTriggerStrings", "bracketMatching", "closeBrackets", "cursorWide", "cypherLanguage",
// "autofocus",
"history", "indentUnit", "lineNumberFormatter", "lineNumbers", "lineWrapping", "lint", "placeholder", "position", "readOnly", "readOnlyCursor", "schema", "search", "searchMatches", "searchOpen", "searchText", "searchTop", "selection", "tabKey", "theme", "tooltipAbsolute",
// "parseOnSetValue",
"value", "preExtensions", "postExtensions"];
export const isNumber = v => v !== undefined && (typeof v === "number" || v instanceof Number) && isFinite(v);
export const isInteger = v => isNumber(v) && v % 1 === 0;
export const isObject = v => typeof v === "object" && v !== null;
export const isAbsolutePosition = v => isInteger(v) && v >= 0;
export const isLineColumnPosition = v => isObject(v) && isInteger(v.line) && v.line >= 1 && isInteger(v.column) && v.column >= 0;
export const isLineColumnAbsolutePosition = v => isObject(v) && isInteger(v.position) && v.position >= 0;
export const positionColumnNewToOld = _ref => {
  let {
      line,
      column
    } = _ref,
    rest = _objectWithoutProperties(_ref, _excluded);
  return _objectSpread({
    line,
    column: column - 1
  }, rest);
};
export const positionColumnOldToNew = _ref2 => {
  let {
      line,
      column
    } = _ref2,
    rest = _objectWithoutProperties(_ref2, _excluded2);
  return _objectSpread({
    line,
    column: column + 1
  }, rest);
};
export const positionNewToOld = positionValue => isLineColumnPosition(positionValue) ? positionColumnNewToOld(positionValue) : positionValue;
export const positionOldToNew = positionValue => isLineColumnPosition(positionValue) ? positionColumnOldToNew(positionValue) : positionValue;
export const createEventHandlers = () => {
  const listeners = [];
  const off = listener => {
    const index = listeners.findIndex(l => l === listener);
    if (index >= 0) {
      listeners.splice(index, 1);
      return true;
    }
    return false;
  };
  const on = listener => {
    listeners.push(listener);
    return () => {
      off(listener);
    };
  };
  const fire = (...args) => {
    for (let listener of listeners) {
      listener(...args);
    }
  };
  const count = () => {
    return listeners.length;
  };
  return {
    on,
    off,
    listeners,
    fire,
    count
  };
};